/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.custom;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class GuiTeleporterStatus
extends GuiTexturedElement {
    private static final ResourceLocation NEEDS_ENERGY = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "teleporter_needs_energy.png");
    private static final ResourceLocation NO_FRAME = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "teleporter_no_frame.png");
    private static final ResourceLocation NO_FREQUENCY = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "teleporter_no_frequency.png");
    private static final ResourceLocation NO_DESTINATION = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "teleporter_no_link.png");
    private static final ResourceLocation READY = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "teleporter_ready.png");
    private static final Map<TileEntityTeleporter.TeleporterStatus, Tooltip> CACHED_TOOLTIPS = new EnumMap<TileEntityTeleporter.TeleporterStatus, Tooltip>(TileEntityTeleporter.TeleporterStatus.class);
    private final BooleanSupplier hasFrequency;
    private final Supplier<TileEntityTeleporter.TeleporterStatus> statusSupplier;

    public GuiTeleporterStatus(IGuiWrapper gui, BooleanSupplier hasFrequency, Supplier<TileEntityTeleporter.TeleporterStatus> statusSupplier) {
        super(NO_FREQUENCY, gui, 6, 6, 18, 18);
        this.hasFrequency = hasFrequency;
        this.statusSupplier = statusSupplier;
        this.setButtonBackground(GuiElement.ButtonBackground.DEFAULT);
    }

    @Override
    protected int getButtonTextureY(boolean hoveredOrFocused) {
        return 1;
    }

    @Override
    protected ResourceLocation getResource() {
        if (this.hasFrequency.getAsBoolean()) {
            return switch (this.statusSupplier.get()) {
                case TileEntityTeleporter.TeleporterStatus.READY -> READY;
                case TileEntityTeleporter.TeleporterStatus.NO_FRAME -> NO_FRAME;
                case TileEntityTeleporter.TeleporterStatus.NOT_ENOUGH_ENERGY -> NEEDS_ENERGY;
                default -> NO_DESTINATION;
            };
        }
        return NO_FREQUENCY;
    }

    @Override
    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.blit(this.getResource(), this.relativeX, this.relativeY, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
    }

    @Override
    public void updateTooltip(int mouseX, int mouseY) {
        TileEntityTeleporter.TeleporterStatus status = this.hasFrequency.getAsBoolean() ? this.statusSupplier.get() : TileEntityTeleporter.TeleporterStatus.NO_FREQUENCY;
        Tooltip statusDisplay = CACHED_TOOLTIPS.computeIfAbsent(status, s -> Tooltip.create((Component)s.getTextComponent()));
        this.setTooltip(statusDisplay);
    }
}

