/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mekanism.client.model.MekanismJavaModel;
import mekanism.client.model.ModelPartData;
import mekanism.client.render.MekanismRenderType;
import mekanism.common.Mekanism;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.NotNull;

public class ModelIndustrialAlarm
extends MekanismJavaModel {
    public static final ModelLayerLocation ALARM_LAYER = new ModelLayerLocation(Mekanism.rl("industrial_alarm"), "main");
    private static final ResourceLocation TEXTURE_ACTIVE = MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "industrial_alarm_active.png");
    private static final ModelPartData BULB = new ModelPartData("bulb", CubeListBuilder.create().texOffs(16, 0).addBox(-1.0f, 1.0f, -1.0f, 2.0f, 3.0f, 2.0f), new ModelPartData[0]);
    private static final ModelPartData LIGHT_BOX = new ModelPartData("light_box", CubeListBuilder.create().addBox(-2.0f, 1.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.01f)), new ModelPartData[0]);
    private static final ModelPartData AURA = new ModelPartData("aura", CubeListBuilder.create().texOffs(0, 16).addBox(-6.0f, 2.0f, -1.0f, 12.0f, 1.0f, 2.0f, new CubeDeformation(0.01f)), new ModelPartData[0]);
    private final RenderType RENDER_TYPE = this.renderType(TEXTURE_ACTIVE);
    private final ModelPart bulb;
    private final ModelPart lightBox;
    private final ModelPart aura;

    public static LayerDefinition createLayerDefinition() {
        return ModelIndustrialAlarm.createLayerDefinition(64, 64, BULB, LIGHT_BOX, AURA);
    }

    public ModelIndustrialAlarm(EntityModelSet entityModelSet) {
        super(MekanismRenderType.ALARM);
        ModelPart root = entityModelSet.bakeLayer(ALARM_LAYER);
        this.bulb = BULB.getFromRoot(root);
        this.lightBox = LIGHT_BOX.getFromRoot(root);
        this.aura = AURA.getFromRoot(root);
    }

    public void renderToBuffer(@NotNull PoseStack matrix, @NotNull VertexConsumer vertexBuilder, int light, int overlayLight, int color) {
        this.render(matrix, vertexBuilder, 0xF000F0, overlayLight, color, 0.0f);
    }

    public RenderType getRenderType() {
        return this.RENDER_TYPE;
    }

    public void render(@NotNull PoseStack matrix, @NotNull VertexConsumer vertexBuilder, int light, int overlayLight, int color, float rotation) {
        float yRot = rotation * ((float)Math.PI / 180);
        ModelIndustrialAlarm.setRotation(this.aura, 0.0f, yRot, 0.0f);
        ModelIndustrialAlarm.setRotation(this.bulb, 0.0f, yRot, 0.0f);
        float bulbAlpha = 0.3f + Math.abs(rotation * 2.0f % 360.0f - 180.0f) / 180.0f * 0.7f;
        int bulbColor = FastColor.ARGB32.color((int)FastColor.as8BitChannel((float)bulbAlpha), (int)color);
        this.bulb.render(matrix, vertexBuilder, light, overlayLight, bulbColor);
        this.lightBox.render(matrix, vertexBuilder, light, overlayLight, color);
        this.aura.render(matrix, vertexBuilder, light, overlayLight, bulbColor);
    }
}

