/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.sound;

import java.util.Objects;
import mekanism.client.sound.PlayerSound;
import mekanism.common.lib.radiation.ClientRadiation;
import mekanism.common.lib.radiation.RadiationScale;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class GeigerSound
extends PlayerSound {
    private final RadiationScale scale;

    public static GeigerSound create(@NotNull Player player, RadiationScale scale) {
        int subtitleFrequency = switch (scale) {
            default -> throw new MatchException(null, null);
            case RadiationScale.LOW -> 60;
            case RadiationScale.MEDIUM -> 50;
            case RadiationScale.ELEVATED -> 40;
            case RadiationScale.HIGH -> 30;
            case RadiationScale.EXTREME -> 20;
            case RadiationScale.NONE -> throw new IllegalArgumentException("Can't create a GeigerSound with a RadiationScale of NONE.");
        };
        return new GeigerSound(player, scale, subtitleFrequency);
    }

    private GeigerSound(@NotNull Player player, RadiationScale scale, int subtitleFrequency) {
        super(player, Objects.requireNonNull(scale.getSoundEvent()), subtitleFrequency);
        this.scale = scale;
        this.setFade(1.0f, 1.0f);
    }

    @Override
    public boolean shouldPlaySound(@NotNull Player player) {
        return this.scale == ClientRadiation.getClientScale();
    }

    @Override
    public float getVolume() {
        return super.getVolume() * 0.05f;
    }
}

