/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import mekanism.api.SerializerHelper;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.Mekanism;
import mekanism.common.content.assemblicator.RecipeFormula;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

@NothingNullByDefault
public record FormulaAttachment(List<ItemStack> inventory, boolean invalid) {
    public static final FormulaAttachment EMPTY = new FormulaAttachment((List<ItemStack>)NonNullList.withSize((int)9, (Object)ItemStack.EMPTY), false);
    public static final Codec<FormulaAttachment> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)SerializerHelper.OPTIONAL_SINGLE_ITEM_CODEC.listOf(9, 9).fieldOf("items").forGetter(FormulaAttachment::inventory), (App)Codec.BOOL.optionalFieldOf("invalid", (Object)false).forGetter(FormulaAttachment::invalid)).apply((Applicative)instance, FormulaAttachment::new)).orElse(error -> Mekanism.logger.error("Failed to load stored formula: {}", error), (Object)EMPTY);
    public static final StreamCodec<RegistryFriendlyByteBuf, FormulaAttachment> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_LIST_STREAM_CODEC, FormulaAttachment::inventory, (StreamCodec)ByteBufCodecs.BOOL, FormulaAttachment::invalid, FormulaAttachment::new);

    public FormulaAttachment {
        inventory = Collections.unmodifiableList(inventory);
    }

    public static FormulaAttachment create(RecipeFormula formula) {
        return new FormulaAttachment(formula.getCopy(true), false);
    }

    public FormulaAttachment asInvalid() {
        if (this.invalid) {
            return this;
        }
        return new FormulaAttachment(this.inventory, true);
    }

    public boolean isEmpty() {
        if (this == EMPTY) {
            return true;
        }
        return this.inventory.stream().allMatch(ItemStack::isEmpty);
    }

    public Stream<ItemStack> nonEmptyItems() {
        if (this == EMPTY) {
            return Stream.empty();
        }
        return this.inventory.stream().filter(stack -> !stack.isEmpty());
    }

    public boolean hasItems() {
        if (this == EMPTY) {
            return false;
        }
        return this.inventory.stream().anyMatch(stack -> !stack.isEmpty());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormulaAttachment other = (FormulaAttachment)o;
        return this.invalid == other.invalid && ItemStack.listMatches(this.inventory, other.inventory);
    }

    @Override
    public int hashCode() {
        int hash = ItemStack.hashStackList(this.inventory);
        return 31 * hash + Boolean.hashCode(this.invalid);
    }
}

