/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.merged;

import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.common.capabilities.fluid.FluidTankWrapper;
import mekanism.common.capabilities.merged.ChemicalTankWrapper;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;

@NothingNullByDefault
public class MergedTank {
    private final IExtendedFluidTank fluidTank;
    private final IChemicalTank chemicalTank;

    public static MergedTank create(IExtendedFluidTank fluidTank, IChemicalTank gasTank) {
        Objects.requireNonNull(fluidTank, "Fluid tank cannot be null");
        Objects.requireNonNull(gasTank, "Gas tank cannot be null");
        return new MergedTank(fluidTank, gasTank);
    }

    private MergedTank(IExtendedFluidTank fluidTank, IChemicalTank chemicalTank) {
        this.fluidTank = new FluidTankWrapper(this, fluidTank, chemicalTank);
        this.chemicalTank = new ChemicalTankWrapper(this, chemicalTank, this.fluidTank::isEmpty);
    }

    public CurrentType getCurrentType() {
        if (!this.getFluidTank().isEmpty()) {
            return CurrentType.FLUID;
        }
        return this.chemicalTank.isEmpty() ? CurrentType.EMPTY : CurrentType.CHEMICAL;
    }

    public final IExtendedFluidTank getFluidTank() {
        return this.fluidTank;
    }

    public final IChemicalTank getChemicalTank() {
        return this.chemicalTank;
    }

    public void addToUpdateTag(HolderLookup.Provider provider, CompoundTag updateTag) {
        updateTag.put("fluid", this.fluidTank.getFluid().saveOptional(provider));
        updateTag.put("chemical", this.chemicalTank.getStack().saveOptional(provider));
    }

    public void readFromUpdateTag(HolderLookup.Provider provider, CompoundTag tag) {
        NBTUtils.setFluidStackIfPresent(provider, tag, "fluid", this.fluidTank::setStack);
        NBTUtils.setChemicalStackIfPresent(provider, tag, "chemical", this.chemicalTank::setStack);
    }

    public static enum CurrentType {
        EMPTY,
        FLUID,
        CHEMICAL;

    }
}

