/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.entity.ai;

import java.util.EnumSet;
import mekanism.common.entity.EntityRobit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public abstract class RobitAIBase
extends Goal {
    protected final EntityRobit theRobit;
    protected final float moveSpeed;
    private int timeToRecalcPath;
    private float oldWaterCost;

    protected RobitAIBase(EntityRobit entityRobit, float speed) {
        this.theRobit = entityRobit;
        this.moveSpeed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    protected PathNavigation getNavigator() {
        return this.theRobit.getNavigation();
    }

    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.theRobit.getPathfindingMalus(PathType.WATER);
        this.theRobit.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public void stop() {
        this.getNavigator().stop();
        this.theRobit.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
    }

    protected void updateTask(Entity target) {
        this.theRobit.getLookControl().setLookAt(target, 6.0f, (float)this.theRobit.getMaxHeadXRot() / 10.0f);
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.theRobit.isPassenger()) {
                if (this.theRobit.distanceToSqr(target) >= 144.0) {
                    this.teleportToAroundBlockPos(target.blockPosition());
                } else {
                    this.getNavigator().moveTo(target, (double)this.moveSpeed);
                }
            }
        }
    }

    private void teleportToAroundBlockPos(BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            int j = this.theRobit.getRandom().nextIntBetweenInclusive(-3, 3);
            int k = this.theRobit.getRandom().nextIntBetweenInclusive(-3, 3);
            if (Math.abs(j) < 2 && Math.abs(k) < 2) continue;
            int l = this.theRobit.getRandom().nextIntBetweenInclusive(-1, 1);
            if (!this.maybeTeleportTo(pos.getX() + j, pos.getY() + l, pos.getZ() + k)) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int x, int y, int z) {
        if (this.canTeleportTo(new BlockPos(x, y, z))) {
            this.theRobit.moveTo((double)x + 0.5, y, (double)z + 0.5, this.theRobit.getYRot(), this.theRobit.getXRot());
            this.getNavigator().stop();
            return true;
        }
        return false;
    }

    private boolean canTeleportTo(BlockPos pos) {
        PathType pathtype = WalkNodeEvaluator.getPathTypeStatic((Mob)this.theRobit, (BlockPos)pos);
        if (pathtype != PathType.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.theRobit.level().getBlockState(pos.below());
        if (blockstate.getBlock() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pos.subtract((Vec3i)this.theRobit.blockPosition());
        return this.theRobit.level().noCollision((Entity)this.theRobit, this.theRobit.getBoundingBox().move(blockpos));
    }
}

