/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.handler;

import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import java.util.Optional;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.common.integration.crafttweaker.CrTRecipeComponents;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.recipe.handler.MekanismRecipeHandler;
import mekanism.common.integration.crafttweaker.recipe.manager.RotaryRecipeManager;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;

@IRecipeHandler.For(value=RotaryRecipe.class)
public class RotaryRecipeHandler
extends MekanismRecipeHandler<RotaryRecipe> {
    public String dumpToCommandString(IRecipeManager<? super RotaryRecipe> manager, RegistryAccess registryAccess, RecipeHolder<RotaryRecipe> recipeHolder) {
        RotaryRecipe recipe = (RotaryRecipe)recipeHolder.value();
        return this.buildCommandString(manager, recipeHolder, recipe.hasFluidToChemical() ? recipe.getFluidInput() : SKIP_OPTIONAL_PARAM, recipe.hasChemicalToFluid() ? recipe.getChemicalInput() : SKIP_OPTIONAL_PARAM, recipe.hasFluidToChemical() ? recipe.getChemicalOutputDefinition() : SKIP_OPTIONAL_PARAM, recipe.hasChemicalToFluid() ? recipe.getFluidOutputDefinition() : SKIP_OPTIONAL_PARAM);
    }

    @Override
    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super RotaryRecipe> manager, RotaryRecipe recipe, U o) {
        if (o instanceof RotaryRecipe) {
            RotaryRecipe other = (RotaryRecipe)o;
            return recipe.hasFluidToChemical() && other.hasFluidToChemical() && this.ingredientConflicts(recipe.getFluidInput(), other.getFluidInput()) || recipe.hasChemicalToFluid() && other.hasChemicalToFluid() && this.ingredientConflicts(recipe.getChemicalInput(), other.getChemicalInput());
        }
        return false;
    }

    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super RotaryRecipe> manager, RegistryAccess registryAccess, RotaryRecipe recipe) {
        if (recipe.hasFluidToChemical()) {
            if (recipe.hasChemicalToFluid()) {
                return this.decompose(recipe.getFluidInput(), recipe.getChemicalInput(), recipe.getChemicalOutputDefinition(), recipe.getFluidOutputDefinition());
            }
            return this.decompose(recipe.getFluidInput(), recipe.getChemicalOutputDefinition());
        }
        return this.decompose(recipe.getChemicalInput(), recipe.getFluidOutputDefinition());
    }

    public Optional<RotaryRecipe> recompose(IRecipeManager<? super RotaryRecipe> m, RegistryAccess registryAccess, IDecomposedRecipe recipe) {
        if (m instanceof RotaryRecipeManager) {
            RotaryRecipeManager manager = (RotaryRecipeManager)m;
            Optional<ChemicalStackIngredient> chemicalInput = CrTUtils.getSingleIfPresent(recipe, CrTRecipeComponents.CHEMICAL.input());
            Optional<IFluidStack> fluidOutput = CrTUtils.getSingleIfPresent(recipe, CrTRecipeComponents.FLUID.output());
            if (chemicalInput.isPresent() != fluidOutput.isPresent()) {
                throw new IllegalArgumentException("Mismatched chemical input and fluid output. Only one is present.");
            }
            Optional<CTFluidIngredient> fluidInput = CrTUtils.getSingleIfPresent(recipe, CrTRecipeComponents.FLUID.input());
            Optional<ICrTChemicalStack> chemicalOutput = CrTUtils.getSingleIfPresent(recipe, CrTRecipeComponents.CHEMICAL.output());
            if (fluidInput.isPresent() != chemicalOutput.isPresent()) {
                throw new IllegalArgumentException("Mismatched fluid input and chemical output. Only one is present.");
            }
            if (chemicalInput.isPresent()) {
                if (fluidInput.isPresent()) {
                    return Optional.of(manager.makeRecipe(fluidInput.get(), chemicalInput.get(), chemicalOutput.get(), fluidOutput.get()));
                }
                return Optional.of(manager.makeRecipe(chemicalInput.get(), fluidOutput.get()));
            }
            if (fluidInput.isPresent()) {
                return Optional.of(manager.makeRecipe(fluidInput.get(), chemicalOutput.get()));
            }
        }
        return Optional.empty();
    }
}

