/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.frequency;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import mekanism.api.security.SecurityMode;
import mekanism.common.lib.frequency.Frequency;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;

public interface IdentitySerializer {
    public static final IdentitySerializer NAME = new IdentitySerializer(){
        private static final Codec<Frequency.FrequencyIdentity> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.NON_EMPTY_STRING.fieldOf("name").forGetter(identity -> identity.key().toString()), (App)SecurityMode.CODEC.fieldOf("security_mode").forGetter(Frequency.FrequencyIdentity::securityMode), (App)UUIDUtil.CODEC.optionalFieldOf("owner").forGetter(identity -> Optional.ofNullable(identity.ownerUUID()))).apply((Applicative)instance, (key, security, owner) -> new Frequency.FrequencyIdentity(key, (SecurityMode)security, owner.orElse(null))));
        private static final StreamCodec<ByteBuf, Frequency.FrequencyIdentity> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, data -> data.key().toString(), SecurityMode.STREAM_CODEC, Frequency.FrequencyIdentity::securityMode, (StreamCodec)ByteBufCodecs.optional((StreamCodec)UUIDUtil.STREAM_CODEC), identity -> Optional.ofNullable(identity.ownerUUID()), (key, security, owner) -> new Frequency.FrequencyIdentity(key, (SecurityMode)security, owner.orElse(null)));

        @Override
        public Codec<Frequency.FrequencyIdentity> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<ByteBuf, Frequency.FrequencyIdentity> streamCodec() {
            return STREAM_CODEC;
        }
    };
    public static final IdentitySerializer UUID = new IdentitySerializer(){
        private static final Codec<Frequency.FrequencyIdentity> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.fieldOf("owner").forGetter(identity -> (UUID)identity.key()), (App)SecurityMode.CODEC.fieldOf("security_mode").forGetter(Frequency.FrequencyIdentity::securityMode)).apply((Applicative)instance, (owner, mode) -> new Frequency.FrequencyIdentity(owner, (SecurityMode)mode, (UUID)owner)));
        private static final StreamCodec<ByteBuf, Frequency.FrequencyIdentity> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, data -> (UUID)data.key(), SecurityMode.STREAM_CODEC, Frequency.FrequencyIdentity::securityMode, (owner, security) -> new Frequency.FrequencyIdentity(owner, (SecurityMode)security, (UUID)owner));

        @Override
        public Codec<Frequency.FrequencyIdentity> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<ByteBuf, Frequency.FrequencyIdentity> streamCodec() {
            return STREAM_CODEC;
        }
    };

    public Codec<Frequency.FrequencyIdentity> codec();

    public StreamCodec<ByteBuf, Frequency.FrequencyIdentity> streamCodec();
}

