/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.security;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import mekanism.api.security.SecurityMode;
import mekanism.common.lib.collection.HashList;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.network.PacketUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.Nullable;

public class SecurityFrequency
extends Frequency {
    public static final String SECURITY = "Security";
    public static final Codec<SecurityFrequency> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.optionalFieldOf("owner").forGetter(freq -> Optional.ofNullable(freq.getOwner())), (App)SecurityMode.CODEC.fieldOf("security_mode").forGetter(Frequency::getSecurity), (App)Codec.BOOL.fieldOf("override").forGetter(SecurityFrequency::isOverridden), (App)UUIDUtil.CODEC.listOf().optionalFieldOf("trusted").forGetter(freq -> freq.trusted.isEmpty() ? Optional.empty() : Optional.of(freq.trusted.elements()))).apply((Applicative)instance, (owner, securityMode, override, trustedCache) -> {
        SecurityFrequency frequency = new SecurityFrequency(owner.orElse(null), (SecurityMode)securityMode);
        frequency.override = override;
        for (UUID trusted : trustedCache.orElse(Collections.emptyList())) {
            frequency.addTrustedRaw(trusted, MekanismUtils.getLastKnownUsername(trusted));
        }
        return frequency;
    }));
    public static final StreamCodec<ByteBuf, SecurityFrequency> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)UUIDUtil.STREAM_CODEC), freq -> Optional.ofNullable(freq.getOwner()), (StreamCodec)ByteBufCodecs.stringUtf8((int)PacketUtils.LAST_USERNAME_LENGTH), Frequency::getOwnerName, SecurityMode.STREAM_CODEC, Frequency::getSecurity, (StreamCodec)ByteBufCodecs.BOOL, SecurityFrequency::isOverridden, (StreamCodec)ByteBufCodecs.stringUtf8((int)PacketUtils.LAST_USERNAME_LENGTH).apply(buf -> ByteBufCodecs.collection(HashList::new, (StreamCodec)buf)), freq -> freq.trustedCache, (owner, ownerName, securityMode, override, trustedCache) -> {
        SecurityFrequency frequency = new SecurityFrequency(owner.orElse(null), (String)ownerName, (SecurityMode)securityMode);
        frequency.override = override;
        frequency.trustedCache = trustedCache;
        return frequency;
    });
    private boolean override = false;
    private final HashList<UUID> trusted = new HashList();
    private HashList<String> trustedCache = new HashList();
    private int trustedCacheHash;

    public SecurityFrequency(@Nullable UUID uuid, SecurityMode securityMode) {
        super(FrequencyType.SECURITY, SECURITY, uuid, securityMode);
    }

    private SecurityFrequency(@Nullable UUID owner, String ownerName, SecurityMode securityMode) {
        super(FrequencyType.SECURITY, SECURITY, owner, ownerName, securityMode);
    }

    @Override
    public UUID getKey() {
        return this.getOwner();
    }

    @Override
    public int getSyncHash() {
        int code = super.getSyncHash();
        code = 31 * code + (this.override ? 1 : 0);
        code = 31 * code + this.getSecurity().ordinal();
        code = 31 * code + this.trustedCacheHash;
        return code;
    }

    public void setOverridden(boolean override) {
        if (this.override != override) {
            this.override = override;
            this.dirty = true;
        }
    }

    @Override
    public Frequency.FrequencyIdentity getIdentity() {
        return new Frequency.FrequencyIdentity(this.getKey(), SecurityMode.PUBLIC, this.getOwner());
    }

    public boolean isOverridden() {
        return this.override;
    }

    public boolean isTrusted(UUID subject) {
        return this.trusted.contains(subject);
    }

    public List<String> getTrustedUsernameCache() {
        return this.trustedCache.elements();
    }

    public void addTrusted(UUID uuid, String name) {
        if (!this.trusted.contains(uuid)) {
            this.addTrustedRaw(uuid, name);
            this.dirty = true;
        }
    }

    private void addTrustedRaw(UUID uuid, String name) {
        this.trusted.add(uuid);
        this.trustedCache.add(name);
        this.trustedCacheHash = this.trustedCache.hashCode();
    }

    @Nullable
    public UUID removeTrusted(int index) {
        UUID uuid = null;
        if (index >= 0 && index < this.trusted.size()) {
            uuid = this.trusted.remove(index);
            this.dirty = true;
        }
        if (index >= 0 && index < this.trustedCache.size()) {
            this.trustedCache.remove(index);
            this.trustedCacheHash = this.trustedCache.hashCode();
        }
        return uuid;
    }
}

