/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import io.netty.buffer.ByteBuf;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public record PacketWindowSelect(@Nullable SelectedWindowData selectedWindow) implements IMekanismPacket
{
    public static final CustomPacketPayload.Type<PacketWindowSelect> TYPE = new CustomPacketPayload.Type(Mekanism.rl("window_select"));
    private static final PacketWindowSelect NO_WINDOW = new PacketWindowSelect(null);
    private static final StreamCodec<ByteBuf, PacketWindowSelect> NO_WINDOW_STREAM_CODEC = StreamCodec.unit((Object)NO_WINDOW);
    public static final StreamCodec<ByteBuf, PacketWindowSelect> STREAM_CODEC = ByteBufCodecs.BYTE.dispatch(packet -> packet.selectedWindow == null ? (byte)-1 : packet.selectedWindow.extraData, extraData -> {
        if (extraData == -1) {
            return NO_WINDOW_STREAM_CODEC;
        }
        return SelectedWindowData.WindowType.STREAM_CODEC.map(windowType -> new PacketWindowSelect(windowType == SelectedWindowData.WindowType.UNSPECIFIED ? SelectedWindowData.UNSPECIFIED : new SelectedWindowData((SelectedWindowData.WindowType)((Object)((Object)windowType)), (byte)extraData)), packet -> packet.selectedWindow.type);
    });

    @NotNull
    public CustomPacketPayload.Type<PacketWindowSelect> type() {
        return TYPE;
    }

    @Override
    public void handle(IPayloadContext context) {
        Player player = context.player();
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof MekanismContainer) {
            MekanismContainer container = (MekanismContainer)abstractContainerMenu;
            container.setSelectedWindow(player.getUUID(), this.selectedWindow);
        }
    }
}

