/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.craftinggrid;

import java.util.ArrayList;
import java.util.List;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsstorage.craftinggrid.CraftingGrid;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridInventory;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridProvider;
import mcjty.rftoolsstorage.craftinggrid.PacketGridSync;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketGridToServer(PacketGridSync sync, List<ItemStack> stacks) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"rftoolsstorage", (String)"gridtoserver");
    public static final CustomPacketPayload.Type<PacketGridToServer> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketGridToServer> CODEC = StreamCodec.composite(PacketGridSync.STREAM_CODEC, PacketGridToServer::sync, (StreamCodec)ItemStack.OPTIONAL_LIST_STREAM_CODEC, PacketGridToServer::stacks, PacketGridToServer::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static PacketGridToServer create(BlockPos pos, ResourceKey<Level> type, CraftingGrid grid) {
        PacketGridSync sync = new PacketGridSync(pos, type, grid);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < 10; ++i) {
            stacks.add(grid.getCraftingGridInventory().getStackInSlot(i));
        }
        return new PacketGridToServer(sync, stacks);
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            Level world = player.getCommandSenderWorld();
            CraftingGridProvider provider = this.sync.handleMessage((Level)LevelTools.getLevel((Level)world, this.sync.type()), player);
            if (provider != null) {
                CraftingGridInventory inventory = provider.getCraftingGrid().getCraftingGridInventory();
                for (int i = 0; i < 10; ++i) {
                    inventory.setStackInSlot(i, this.stacks.get(i));
                }
                provider.markInventoryDirty();
            }
        });
    }
}

