/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.modularstorage.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.UUID;
import mcjty.lib.varia.CompositeStreamCodec;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record StorageModuleData(int id, int version, int infoAmount, UUID uuid, long creationTime, long updateTime, String createdBy) {
    public static final StorageModuleData DEFAULT = new StorageModuleData(-1, 0, -1, null, -1L, -1L, null);
    public static final Codec<StorageModuleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("id").forGetter(StorageModuleData::id), (App)Codec.INT.fieldOf("version").forGetter(StorageModuleData::version), (App)Codec.INT.fieldOf("infoAmount").forGetter(StorageModuleData::infoAmount), (App)UUIDUtil.CODEC.optionalFieldOf("uuid").forGetter(s -> Optional.ofNullable(s.uuid)), (App)Codec.LONG.fieldOf("creation").forGetter(StorageModuleData::creationTime), (App)Codec.LONG.fieldOf("update").forGetter(StorageModuleData::updateTime), (App)Codec.STRING.optionalFieldOf("createdBy").forGetter(s -> Optional.ofNullable(s.createdBy))).apply((Applicative)instance, (id, vs, ia, uuid, creation, update, cb) -> new StorageModuleData((int)id, (int)vs, (int)ia, uuid.orElse(null), (long)creation, (long)update, cb.orElse(null))));
    public static final StreamCodec<RegistryFriendlyByteBuf, StorageModuleData> STREAM_CODEC = CompositeStreamCodec.composite((StreamCodec)ByteBufCodecs.INT, StorageModuleData::id, (StreamCodec)ByteBufCodecs.INT, StorageModuleData::version, (StreamCodec)ByteBufCodecs.INT, StorageModuleData::infoAmount, (StreamCodec)ByteBufCodecs.optional((StreamCodec)UUIDUtil.STREAM_CODEC), s -> Optional.ofNullable(s.uuid), (StreamCodec)ByteBufCodecs.VAR_LONG, StorageModuleData::creationTime, (StreamCodec)ByteBufCodecs.VAR_LONG, StorageModuleData::updateTime, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), s -> Optional.ofNullable(s.createdBy), (id, vs, ia, uuid, creation, update, cb) -> new StorageModuleData((int)id, (int)vs, (int)ia, uuid.orElse(null), (long)creation, (long)update, cb.orElse(null)));

    public StorageModuleData withId(int id) {
        return new StorageModuleData(id, this.version, this.infoAmount, this.uuid, this.creationTime, this.updateTime, this.createdBy);
    }

    public StorageModuleData withUuid(UUID uuid) {
        return new StorageModuleData(this.id, this.version, this.infoAmount, uuid, this.creationTime, this.updateTime, this.createdBy);
    }

    public StorageModuleData withVersion(int version) {
        return new StorageModuleData(this.id, version, this.infoAmount, this.uuid, this.creationTime, this.updateTime, this.createdBy);
    }

    public StorageModuleData withInfoAmount(int infoAmount) {
        return new StorageModuleData(this.id, this.version, infoAmount, this.uuid, this.creationTime, this.updateTime, this.createdBy);
    }

    public StorageModuleData withCreationTime(long creationTime) {
        return new StorageModuleData(this.id, this.version, this.infoAmount, this.uuid, creationTime, this.updateTime, this.createdBy);
    }

    public StorageModuleData withUpdateTime(long updateTime) {
        return new StorageModuleData(this.id, this.version, this.infoAmount, this.uuid, this.creationTime, updateTime, this.createdBy);
    }

    public StorageModuleData withCreatedBy(String createdBy) {
        return new StorageModuleData(this.id, this.version, this.infoAmount, this.uuid, this.creationTime, this.updateTime, createdBy);
    }
}

