/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.blazing.blocks;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.container.ItemInventory;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.api.infusable.ItemInfusable;
import mcjty.lib.api.power.ItemEnergy;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.setup.Registration;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.RedstoneMode;
import mcjty.lib.varia.Sync;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.blazing.BlazingConfiguration;
import mcjty.rftoolspower.modules.blazing.BlazingModule;
import mcjty.rftoolspower.modules.blazing.items.BlazingRod;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.util.Lazy;

public class BlazingGeneratorTileEntity
extends TickingTileEntity {
    public static final int BUFFER_SIZE = 4;
    public static final BooleanProperty WORKING = BooleanProperty.create((String)"working");
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(4).slot(SlotDefinition.specific((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)BlazingModule.BLAZING_ROD.get())}).in(), 0, 10, 7).slot(SlotDefinition.specific((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)BlazingModule.BLAZING_ROD.get())}).in(), 1, 82, 7).slot(SlotDefinition.specific((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)BlazingModule.BLAZING_ROD.get())}).in(), 2, 10, 43).slot(SlotDefinition.specific((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)BlazingModule.BLAZING_ROD.get())}).in(), 3, 82, 43).playerSlots(10, 70));
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).slotLimit(1).itemValid(GenericItemHandler.match(BlazingModule.BLAZING_ROD)).onUpdate((slot, stack) -> this.updateSlot((int)slot)).build();
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private static final Function<BlazingGeneratorTileEntity, GenericItemHandler> ITEM_CAP = tile -> tile.items;
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, false, (long)((Integer)BlazingConfiguration.GENERATOR_MAXENERGY.get()).intValue(), 0L);
    @Cap(type=CapType.ENERGY)
    private static final Function<BlazingGeneratorTileEntity, GenericEnergyStorage> ENERGY_CAP = tile -> tile.energyStorage;
    private final DefaultInfusable infusable = new DefaultInfusable((BlockEntity)this);
    @Cap(type=CapType.INFUSABLE)
    private static final Function<BlazingGeneratorTileEntity, IInfusable> INFUSABLE_CAP = tile -> tile.infusable;
    private final int[] rfPerTickMax = new int[4];
    private final float[] rfPerTick = new float[4];
    private final int[] ticksRemaining = new int[4];
    @Cap(type=CapType.CONTAINER)
    private static final Function<BlazingGeneratorTileEntity, MenuProvider> SCREEN_CAP = be -> new DefaultContainerProvider("Blazing Generator").containerSupplier(DefaultContainerProvider.container(BlazingModule.CONTAINER_BLAZING_GENERATOR, CONTAINER_FACTORY, (GenericTileEntity)be)).itemHandler(() -> be.items).energyHandler(() -> be.energyStorage).shortListener(Sync.integer(() -> (int)be.rfPerTick[0], v -> {
        be.rfPerTick[0] = v.intValue();
    })).shortListener(Sync.integer(() -> (int)be.rfPerTick[1], v1 -> {
        be.rfPerTick[1] = v1.intValue();
    })).shortListener(Sync.integer(() -> (int)be.rfPerTick[2], v2 -> {
        be.rfPerTick[2] = v2.intValue();
    })).shortListener(Sync.integer(() -> (int)be.rfPerTick[3], v3 -> {
        be.rfPerTick[3] = v3.intValue();
    })).setupSync((GenericTileEntity)be);

    public BlazingGeneratorTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlazingModule.BLAZING_GENERATOR.be().get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().properties(BlockBehaviour.Properties.of().strength(2.0f).sound(SoundType.METAL)).topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).infusable().manualEntry(ManualHelper.create((String)"rftoolsbase:powergeneration/blazinggenerator")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()}).tileEntitySupplier(BlazingGeneratorTileEntity::new)){

            protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
                super.createBlockStateDefinition(builder);
                builder.add(new Property[]{WORKING});
            }
        };
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    protected void tickServer() {
        this.handleSendingEnergy();
        this.handlePowerGeneration();
    }

    public void setPowerInput(int powered) {
        if (this.powerLevel != powered) {
            super.setPowerInput(powered);
            for (int i = 0; i < 4; ++i) {
                this.updateSlot(i);
            }
        }
    }

    public void setRSMode(RedstoneMode redstoneMode) {
        super.setRSMode(redstoneMode);
        for (int i = 0; i < 4; ++i) {
            this.updateSlot(i);
        }
    }

    public float getRfPerTick(int slot) {
        return this.rfPerTick[slot];
    }

    private void handleSendingEnergy() {
        long storedPower = this.energyStorage.getEnergy();
        EnergyTools.handleSendingEnergy((Level)this.level, (BlockPos)this.worldPosition, (long)storedPower, (long)((Integer)BlazingConfiguration.GENERATOR_SENDPERTICK.get()).intValue(), (GenericEnergyStorage)this.energyStorage);
    }

    private void handlePowerGeneration() {
        int totalRfGenerated = 0;
        for (int i = 0; i < 4; ++i) {
            if (this.rfPerTick[i] > (float)this.rfPerTickMax[i]) {
                int n = i;
                this.rfPerTick[n] = this.rfPerTick[n] + ((float)this.rfPerTickMax[i] - this.rfPerTick[i]) / 30.0f;
                if (this.rfPerTick[i] < (float)this.rfPerTickMax[i]) {
                    this.rfPerTick[i] = this.rfPerTickMax[i];
                }
            } else if (this.rfPerTick[i] < (float)this.rfPerTickMax[i]) {
                int n = i;
                this.rfPerTick[n] = this.rfPerTick[n] + (((float)this.rfPerTickMax[i] - this.rfPerTick[i]) / 150.0f + 0.01f);
                if (this.rfPerTick[i] > (float)this.rfPerTickMax[i]) {
                    this.rfPerTick[i] = this.rfPerTickMax[i];
                }
            }
            totalRfGenerated += (int)this.rfPerTick[i];
            if (!this.isMachineEnabled()) continue;
            int n = i;
            this.ticksRemaining[n] = this.ticksRemaining[n] - 1;
            ItemStack stack = this.items.getStackInSlot(i);
            if (this.ticksRemaining[i] <= 0) {
                this.ticksRemaining[i] = 0;
                this.rfPerTickMax[i] = 0;
                if (stack.isEmpty()) continue;
                this.items.setStackInSlot(i, ItemStack.EMPTY);
                continue;
            }
            if (stack.isEmpty()) continue;
            BlazingRod.setPowerDuration(stack, this.ticksRemaining[i]);
        }
        this.energyStorage.produceEnergy((long)totalRfGenerated);
        boolean generating = totalRfGenerated > 0;
        BlockState state = this.level.getBlockState(this.worldPosition);
        if ((Boolean)state.getValue((Property)WORKING) != generating) {
            this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)WORKING, (Comparable)Boolean.valueOf(generating)), 3);
        }
        this.markDirtyQuick();
    }

    private void updateSlot(int slot) {
        ItemStack stack = this.items.getStackInSlot(slot);
        if (stack.isEmpty() || !this.isMachineEnabled()) {
            this.rfPerTickMax[slot] = 0;
            this.ticksRemaining[slot] = 0;
        } else {
            this.rfPerTickMax[slot] = (int)((float)BlazingRod.getRfPerTick(stack) * (this.infusable.getInfusedFactor() * 0.1f + 1.0f));
            this.ticksRemaining[slot] = BlazingRod.getTotalTicks(stack);
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        for (int i = 0; i < 4; ++i) {
            this.rfPerTickMax[i] = tag.getInt("rftMax" + i);
            this.rfPerTick[i] = tag.getFloat("rft" + i);
            this.ticksRemaining[i] = tag.getInt("ticks" + i);
        }
        this.energyStorage.load(tag, "energy", provider);
        this.items.load(tag, "items", provider);
        this.infusable.load(tag, "infusable");
    }

    public void saveAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        for (int i = 0; i < 4; ++i) {
            tag.putInt("rftMax" + i, this.rfPerTickMax[i]);
            tag.putFloat("rft" + i, this.rfPerTick[i]);
            tag.putInt("ticks" + i, this.ticksRemaining[i]);
        }
        this.energyStorage.save(tag, "energy", provider);
        this.items.save(tag, "items", provider);
        this.infusable.save(tag, "infusable");
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.energyStorage.applyImplicitComponents((ItemEnergy)input.get((Supplier)Registration.ITEM_ENERGY));
        this.items.applyImplicitComponents((ItemInventory)input.get((Supplier)Registration.ITEM_INVENTORY));
        this.infusable.applyImplicitComponents((ItemInfusable)input.get((Supplier)Registration.ITEM_INFUSABLE));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        this.energyStorage.collectImplicitComponents(builder);
        this.items.collectImplicitComponents(builder);
        this.infusable.collectImplicitComponents(builder);
    }
}

