/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.dimensionalcell.client;

import javax.annotation.Nonnull;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.network.Networking;
import mcjty.lib.network.PacketRequestDataFromServer;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellConfiguration;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellModule;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellBlock;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellTileEntity;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

public class GuiDimensionalCell
extends GenericGuiContainer<DimensionalCellTileEntity, GenericContainer> {
    public static final int POWERCELL_WIDTH = 180;
    public static final int POWERCELL_HEIGHT = 152;
    private EnergyBar energyBar;
    private Button stats;
    private static long lastTime = 0L;
    private static final ResourceLocation iconLocation = ResourceLocation.fromNamespaceAndPath((String)"rftoolspower", (String)"textures/gui/dimensionalcell.png");

    public GuiDimensionalCell(GenericContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title, ((DimensionalCellBlock)((Object)DimensionalCellModule.DIMENSIONAL_CELL.block().get())).getManualEntry());
        this.imageWidth = 180;
        this.imageHeight = 152;
    }

    public static void register(RegisterMenuScreensEvent event) {
        event.register(DimensionalCellModule.CONTAINER_DIMENSIONAL_CELL.get(), GuiDimensionalCell::new);
    }

    public void init() {
        super.init();
        this.energyBar = ((EnergyBar)new EnergyBar().vertical().maxValue(1000L).hint(10, 7, 8, 54)).showText(false);
        this.energyBar.value(0L);
        Button allNone = (Button)((Button)Widgets.button((int)140, (int)10, (int)32, (int)15, (String)"None").name("allnone")).tooltips(new String[]{"Set all sides to 'none'"});
        Button allInput = (Button)((Button)Widgets.button((int)140, (int)27, (int)32, (int)15, (String)"In").name("allinput")).tooltips(new String[]{"Set all sides to", "accept energy"});
        Button allOutput = (Button)((Button)Widgets.button((int)140, (int)44, (int)32, (int)15, (String)"Out").name("alloutput")).tooltips(new String[]{"Set all sides to", "send energy"});
        this.stats = (Button)((Button)Widgets.button((int)100, (int)10, (int)32, (int)15, (String)"Stats").name("clearstats")).tooltips(new String[]{"Power statistics. Press to clear:"});
        Label label = (Label)Widgets.label((int)26, (int)30, (int)40, (int)18, (String)"Link:").tooltips(new String[]{"Link a powercard to card", "on the left"});
        Panel toplevel = (Panel)((Panel)Widgets.positional().background(iconLocation)).children(new Widget[]{this.energyBar, allNone, allInput, allOutput, label, this.stats});
        toplevel.bounds(this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        this.window.action("allnone", this.getBE(), DimensionalCellTileEntity.ACTION_SETNONE);
        this.window.action("allinput", this.getBE(), DimensionalCellTileEntity.ACTION_SETINPUT);
        this.window.action("alloutput", this.getBE(), DimensionalCellTileEntity.ACTION_SETOUTPUT);
        this.window.action("clearstats", this.getBE(), DimensionalCellTileEntity.ACTION_CLEARSTATS);
        this.requestRF();
    }

    private void requestRF() {
        if (System.currentTimeMillis() - lastTime > 250L) {
            lastTime = System.currentTimeMillis();
            Networking.sendToServer((CustomPacketPayload)PacketRequestDataFromServer.create((ResourceKey)this.getBE().getDimension(), (BlockPos)this.getBE().getBlockPos(), (String)DimensionalCellTileEntity.CMD_GET_INFO.name(), (TypedMap)TypedMap.EMPTY, (boolean)false));
        }
    }

    protected void renderBg(@Nonnull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        this.drawWindow(graphics, partialTicks, mouseX, mouseY);
        this.requestRF();
        DimensionalCellTileEntity tileEntity = (DimensionalCellTileEntity)this.getBE();
        this.stats.tooltips(new String[]{"Power statistics. Press to clear:", "Inserted: " + tileEntity.tooltipInserted, "Extracted: " + tileEntity.tooltipExtracted});
        int maxValue = (tileEntity.tooltipBlocks - tileEntity.tooltipAdvancedBlocks - tileEntity.tooltipSimpleBlocks) * (Integer)DimensionalCellConfiguration.rfPerNormalCell.get();
        maxValue += tileEntity.tooltipAdvancedBlocks * (Integer)DimensionalCellConfiguration.rfPerNormalCell.get() * (Integer)DimensionalCellConfiguration.advancedFactor.get();
        this.energyBar.maxValue((long)(maxValue += tileEntity.tooltipSimpleBlocks * (Integer)DimensionalCellConfiguration.rfPerNormalCell.get() / (Integer)DimensionalCellConfiguration.simpleFactor.get()));
        this.energyBar.value((long)tileEntity.tooltipEnergy);
    }
}

