/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.clipboard;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllDataComponents;
import com.simibubi.create.AllPackets;
import com.simibubi.create.content.equipment.clipboard.ClipboardBlockEntity;
import com.simibubi.create.foundation.utility.CreateComponentProcessors;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecBuilders;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.createmod.catnip.net.base.ServerboundPacketPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public record ClipboardEditPacket(int hotbarSlot, DataComponentPatch dataComponentPatch, @Nullable BlockPos targetedBlock) implements ServerboundPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, ClipboardEditPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ClipboardEditPacket::hotbarSlot, (StreamCodec)DataComponentPatch.STREAM_CODEC, ClipboardEditPacket::dataComponentPatch, (StreamCodec)CatnipStreamCodecBuilders.nullable((StreamCodec)BlockPos.STREAM_CODEC), ClipboardEditPacket::targetedBlock, ClipboardEditPacket::new);

    public void handle(ServerPlayer sender) {
        DataComponentPatch processedData = CreateComponentProcessors.clipboardProcessor(this.dataComponentPatch);
        if (this.targetedBlock != null) {
            Level world = sender.level();
            if (!world.isLoaded(this.targetedBlock)) {
                return;
            }
            if (!this.targetedBlock.closerThan((Vec3i)sender.blockPosition(), 20.0)) {
                return;
            }
            BlockEntity blockEntity = world.getBlockEntity(this.targetedBlock);
            if (blockEntity instanceof ClipboardBlockEntity) {
                ClipboardBlockEntity cbe = (ClipboardBlockEntity)blockEntity;
                if (processedData.isEmpty()) {
                    ClipboardEditPacket.clearComponents(cbe.dataContainer);
                } else {
                    cbe.dataContainer.remove(AllDataComponents.CLIPBOARD_PREVIOUSLY_OPENED_PAGE);
                    cbe.dataContainer.applyComponents(processedData);
                }
                cbe.onEditedBy((Player)sender);
            }
            return;
        }
        ItemStack itemStack = sender.getInventory().getItem(this.hotbarSlot);
        if (!AllBlocks.CLIPBOARD.isIn(itemStack)) {
            return;
        }
        if (processedData.isEmpty()) {
            ClipboardEditPacket.clearComponents(itemStack);
        } else {
            itemStack.remove(AllDataComponents.CLIPBOARD_PREVIOUSLY_OPENED_PAGE);
            itemStack.applyComponents(processedData);
        }
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return AllPackets.CLIPBOARD_EDIT;
    }

    private static void clearComponents(ItemStack stack) {
        stack.remove(AllDataComponents.CLIPBOARD_TYPE);
        stack.remove(AllDataComponents.CLIPBOARD_PAGES);
        stack.remove(AllDataComponents.CLIPBOARD_READ_ONLY);
        stack.remove(AllDataComponents.CLIPBOARD_COPIED_VALUES);
        stack.remove(AllDataComponents.CLIPBOARD_PREVIOUSLY_OPENED_PAGE);
    }
}

