/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.processing.recipe;

import com.google.common.base.Joiner;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.fluids.FluidStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class ProcessingRecipe<I extends RecipeInput, P extends ProcessingRecipeParams>
implements Recipe<I> {
    protected P params;
    protected NonNullList<Ingredient> ingredients;
    protected NonNullList<ProcessingOutput> results;
    protected NonNullList<FluidIngredient> fluidIngredients;
    protected NonNullList<FluidStack> fluidResults;
    protected int processingDuration;
    protected HeatCondition requiredHeat;
    private RecipeType<?> type;
    private RecipeSerializer<?> serializer;
    private IRecipeTypeInfo typeInfo;
    private Supplier<ItemStack> forcedResult;

    public ProcessingRecipe(IRecipeTypeInfo typeInfo, P params) {
        this.params = params;
        this.ingredients = ((ProcessingRecipeParams)params).ingredients;
        this.fluidIngredients = ((ProcessingRecipeParams)params).fluidIngredients;
        this.results = ((ProcessingRecipeParams)params).results;
        this.fluidResults = ((ProcessingRecipeParams)params).fluidResults;
        this.processingDuration = ((ProcessingRecipeParams)params).processingDuration;
        this.requiredHeat = ((ProcessingRecipeParams)params).requiredHeat;
        this.type = typeInfo.getType();
        this.serializer = typeInfo.getSerializer();
        this.typeInfo = typeInfo;
        this.forcedResult = null;
    }

    protected abstract int getMaxInputCount();

    protected abstract int getMaxOutputCount();

    protected boolean canRequireHeat() {
        return false;
    }

    protected boolean canSpecifyDuration() {
        return false;
    }

    protected int getMaxFluidInputCount() {
        return 0;
    }

    protected int getMaxFluidOutputCount() {
        return 0;
    }

    public List<String> validate() {
        ArrayList<String> errors = new ArrayList<String>();
        int ingredientCount = this.ingredients.size();
        int outputCount = this.results.size();
        if (ingredientCount > this.getMaxInputCount()) {
            errors.add("Recipe has more item inputs (" + ingredientCount + ") than supported (" + this.getMaxInputCount() + ").");
        }
        if (outputCount > this.getMaxOutputCount()) {
            errors.add("Recipe has more item outputs (" + outputCount + ") than supported (" + this.getMaxOutputCount() + ").");
        }
        ingredientCount = this.fluidIngredients.size();
        outputCount = this.fluidResults.size();
        if (ingredientCount > this.getMaxFluidInputCount()) {
            errors.add("Recipe has more fluid inputs (" + ingredientCount + ") than supported (" + this.getMaxFluidInputCount() + ").");
        }
        if (outputCount > this.getMaxFluidOutputCount()) {
            errors.add("Recipe has more fluid outputs (" + outputCount + ") than supported (" + this.getMaxFluidOutputCount() + ").");
        }
        if (this.processingDuration > 0 && !this.canSpecifyDuration()) {
            errors.add("Recipe specified a duration. Durations have no impact on this type of recipe.");
        }
        if (this.requiredHeat != HeatCondition.NONE && !this.canRequireHeat()) {
            errors.add("Recipe specified a heat condition. Heat conditions have no impact on this type of recipe.");
        }
        return errors;
    }

    public P getParams() {
        return this.params;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public NonNullList<FluidIngredient> getFluidIngredients() {
        return this.fluidIngredients;
    }

    public List<ProcessingOutput> getRollableResults() {
        return this.results;
    }

    public NonNullList<FluidStack> getFluidResults() {
        return this.fluidResults;
    }

    public List<ItemStack> getRollableResultsAsItemStacks() {
        return this.getRollableResults().stream().map(ProcessingOutput::getStack).collect(Collectors.toList());
    }

    public void enforceNextResult(Supplier<ItemStack> stack) {
        this.forcedResult = stack;
    }

    public List<ItemStack> rollResults() {
        return this.rollResults(this.getRollableResults());
    }

    public List<ItemStack> rollResults(List<ProcessingOutput> rollableResults) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        for (int i = 0; i < rollableResults.size(); ++i) {
            ItemStack stack;
            ProcessingOutput output = rollableResults.get(i);
            ItemStack itemStack = stack = i == 0 && this.forcedResult != null ? this.forcedResult.get() : output.rollOutput();
            if (stack.isEmpty()) continue;
            results.add(stack);
        }
        return results;
    }

    public int getProcessingDuration() {
        return this.processingDuration;
    }

    public HeatCondition getRequiredHeat() {
        return this.requiredHeat;
    }

    public ItemStack assemble(I t, HolderLookup.Provider provider) {
        return this.getResultItem(provider);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.getRollableResults().isEmpty() ? ItemStack.EMPTY : this.getRollableResults().getFirst().getStack();
    }

    public boolean isSpecial() {
        return true;
    }

    public String getGroup() {
        return "processing";
    }

    public RecipeSerializer<?> getSerializer() {
        return this.serializer;
    }

    public RecipeType<?> getType() {
        return this.type;
    }

    public IRecipeTypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public static <P extends ProcessingRecipeParams, R extends ProcessingRecipe<?, P>> MapCodec<R> codec(Factory<P, R> factory, MapCodec<P> paramsCodec) {
        return paramsCodec.xmap(factory::create, recipe -> recipe.getParams()).validate(recipe -> {
            List<String> errors = recipe.validate();
            if (errors.isEmpty()) {
                return DataResult.success((Object)recipe);
            }
            errors.add(recipe.getClass().getSimpleName() + " failed validation:");
            return DataResult.error(() -> Joiner.on((char)'\n').join((Iterable)errors), (Object)recipe);
        });
    }

    public static <P extends ProcessingRecipeParams, R extends ProcessingRecipe<?, P>> StreamCodec<RegistryFriendlyByteBuf, R> streamCodec(Factory<P, R> factory, StreamCodec<RegistryFriendlyByteBuf, P> streamCodec) {
        return streamCodec.map(factory::create, ProcessingRecipe::getParams);
    }

    @FunctionalInterface
    public static interface Factory<P extends ProcessingRecipeParams, R extends ProcessingRecipe<?, P>> {
        public R create(P var1);
    }
}

