/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.varia.Counter;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbuilder.modules.builder.BlockInformation;
import mcjty.rftoolsbuilder.modules.builder.BuilderConfiguration;
import mcjty.rftoolsbuilder.modules.builder.BuilderModule;
import mcjty.rftoolsbuilder.modules.builder.SpaceChamberRepository;
import mcjty.rftoolsbuilder.modules.builder.blocks.BuilderTileEntity;
import mcjty.rftoolsbuilder.modules.builder.blocks.SupportBlock;
import mcjty.rftoolsbuilder.modules.builder.data.ShapeCardData;
import mcjty.rftoolsbuilder.modules.builder.items.ShapeCardItem;
import mcjty.rftoolsbuilder.modules.builder.items.SpaceChamberCardItem;
import mcjty.rftoolsbuilder.modules.builder.network.PacketChamberInfoReady;
import mcjty.rftoolsbuilder.setup.RFToolsBuilderMessages;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class BuilderTools {
    public static void returnChamberInfo(Player player) {
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = BuilderTools.getSpaceChamberChannel(player);
        if (chamberChannel == null) {
            return;
        }
        ServerLevel world = LevelTools.getLevel((Level)player.getCommandSenderWorld(), chamberChannel.getDimension());
        if (world == null) {
            return;
        }
        Counter blocks = new Counter();
        Counter costs = new Counter();
        HashMap<BlockState, ItemStack> stacks = new HashMap<BlockState, ItemStack>();
        BlockPos minCorner = chamberChannel.getMinCorner();
        BlockPos maxCorner = chamberChannel.getMaxCorner();
        BuilderTools.findBlocks(player, (Level)world, (Counter<BlockState>)blocks, (Counter<BlockState>)costs, stacks, minCorner, maxCorner);
        Counter entitiesWithCount = new Counter();
        Counter entitiesWithCost = new Counter();
        HashMap<String, CompoundTag> firstEntity = new HashMap<String, CompoundTag>();
        BuilderTools.findEntities((Level)world, minCorner, maxCorner, (Counter<String>)entitiesWithCount, (Counter<String>)entitiesWithCost, firstEntity);
        RFToolsBuilderMessages.sendToPlayer(PacketChamberInfoReady.create((Map<BlockState, Integer>)blocks, (Map<BlockState, Integer>)costs, stacks, (Map<String, Integer>)entitiesWithCount, (Map<String, Integer>)entitiesWithCost, firstEntity), player);
    }

    @Nullable
    public static SpaceChamberRepository.SpaceChamberChannel getSpaceChamberChannel(Player player) {
        ItemStack cardItem = player.getItemInHand(InteractionHand.MAIN_HAND);
        return BuilderTools.getSpaceChamberChannel(player.getCommandSenderWorld(), cardItem);
    }

    @Nullable
    public static SpaceChamberRepository.SpaceChamberChannel getSpaceChamberChannel(Level level, ItemStack cardItem) {
        Integer channel = BuilderTools.getChannel(cardItem);
        if (channel == null) {
            return null;
        }
        SpaceChamberRepository repository = SpaceChamberRepository.get(level);
        return repository.getChannel(channel);
    }

    @Nullable
    public static Integer getChannel(ItemStack card) {
        if (card.isEmpty() || !(card.getItem() instanceof ShapeCardItem) && !(card.getItem() instanceof SpaceChamberCardItem)) {
            return null;
        }
        ShapeCardData data = (ShapeCardData)card.get(BuilderModule.ITEM_SHAPECARD_DATA);
        if (data == null) {
            return null;
        }
        int channel = data.channel();
        if (channel == -1) {
            return null;
        }
        return channel;
    }

    private static void findEntities(Level world, BlockPos minCorner, BlockPos maxCorner, Counter<String> entitiesWithCount, Counter<String> entitiesWithCost, Map<String, CompoundTag> firstEntity) {
        List entities = world.getEntities(null, new AABB((double)minCorner.getX(), (double)minCorner.getY(), (double)minCorner.getZ(), (double)(maxCorner.getX() + 1), (double)(maxCorner.getY() + 1), (double)(maxCorner.getZ() + 1)));
        for (Entity entity : entities) {
            ItemEntity entityItem;
            Object canonicalName = entity.getClass().getCanonicalName();
            if (entity instanceof ItemEntity && !(entityItem = (ItemEntity)entity).getItem().isEmpty()) {
                String displayName = entityItem.getItem().getHoverName().getString();
                canonicalName = (String)canonicalName + " (" + displayName + ")";
            }
            ResourceLocation registryName = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
            entitiesWithCount.increment((Object)registryName.toString());
            if (!firstEntity.containsKey(registryName.toString())) {
                CompoundTag entityNBT = new CompoundTag();
                entity.saveWithoutId(entityNBT);
                firstEntity.put(registryName.toString(), entityNBT);
            }
            if (entity instanceof Player) {
                entitiesWithCost.increment((Object)registryName.toString(), ((Integer)BuilderConfiguration.builderRfPerPlayer.get()).intValue());
                continue;
            }
            entitiesWithCost.increment((Object)registryName.toString(), ((Integer)BuilderConfiguration.builderRfPerEntity.get()).intValue());
        }
    }

    private static void findBlocks(Player harvester, Level world, Counter<BlockState> blocks, Counter<BlockState> costs, Map<BlockState, ItemStack> stacks, BlockPos minCorner, BlockPos maxCorner) {
        for (int x = minCorner.getX(); x <= maxCorner.getX(); ++x) {
            for (int y = minCorner.getY(); y <= maxCorner.getY(); ++y) {
                for (int z = minCorner.getZ(); z <= maxCorner.getZ(); ++z) {
                    BlockEntity te;
                    BlockInformation info;
                    ItemStack item;
                    Block block;
                    BlockPos p = new BlockPos(x, y, z);
                    BlockState state = world.getBlockState(p);
                    if (BuilderTileEntity.isEmpty(state, block = state.getBlock())) continue;
                    blocks.increment((Object)state);
                    if (!stacks.containsKey(state) && !(item = block.getCloneItemStack((LevelReader)world, p, state)).isEmpty()) {
                        stacks.put(state, item);
                    }
                    if ((info = BuilderTileEntity.getBlockInformation(harvester, world, p, block, te = world.getBlockEntity(p))).getBlockLevel() == SupportBlock.SupportStatus.STATUS_ERROR) {
                        costs.put((Object)state, (Object)-1);
                        continue;
                    }
                    costs.increment((Object)state, (int)((double)((Integer)BuilderConfiguration.builderRfPerOperation.get()).intValue() * info.getCostFactor()));
                }
            }
        }
    }
}

