/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.items;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.crafting.IComponentsToPreserve;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Check32;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.RLE;
import mcjty.lib.varia.TagTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbuilder.RFToolsBuilder;
import mcjty.rftoolsbuilder.modules.builder.BuilderConfiguration;
import mcjty.rftoolsbuilder.modules.builder.BuilderModule;
import mcjty.rftoolsbuilder.modules.builder.blocks.BuilderTileEntity;
import mcjty.rftoolsbuilder.modules.builder.client.GuiShapeCard;
import mcjty.rftoolsbuilder.modules.builder.data.ShapeCardData;
import mcjty.rftoolsbuilder.modules.builder.items.ShapeCardType;
import mcjty.rftoolsbuilder.shapes.IFormula;
import mcjty.rftoolsbuilder.shapes.Shape;
import mcjty.rftoolsbuilder.shapes.ShapeModifier;
import mcjty.rftoolsbuilder.shapes.StatePalette;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.Lazy;
import org.apache.commons.lang3.StringUtils;

public class ShapeCardItem
extends Item
implements IComponentsToPreserve,
ITooltipSettings {
    private final ShapeCardType type;
    private final Lazy<TooltipBuilder> tooltipBuilder = Lazy.of(() -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbuilder.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.warning(stack -> this.isDisabledInConfig()), TooltipBuilder.header(), TooltipBuilder.parameter((String)"shape", this::getShapeDescription), TooltipBuilder.parameter((String)"dimension", this::getShapeDimension), TooltipBuilder.parameter((String)"offset", this::getShapeOffset), TooltipBuilder.parameter((String)"formulas", stack -> ShapeCardItem.getShape(stack).isComposition(), stack -> "<none>"), TooltipBuilder.parameter((String)"scan", stack -> ShapeCardItem.getShape(stack).isScan(), stack -> "<none>")}));
    public static final int MAXIMUM_COUNT = 50000000;

    public ShapeCardItem(ShapeCardType type) {
        super(RFToolsBuilder.setup.defaultProperties().stacksTo(1).durability(0));
        this.type = type;
    }

    public boolean isDisabledInConfig() {
        if (!((Boolean)BuilderConfiguration.shapeCardAllowed.get()).booleanValue()) {
            return true;
        }
        if (this.type != ShapeCardType.CARD_SHAPE) {
            if (!((Boolean)BuilderConfiguration.quarryAllowed.get()).booleanValue()) {
                return true;
            }
            if (this.type.isQuarry() && this.type.isClearing() && !((Boolean)BuilderConfiguration.clearingQuarryAllowed.get()).booleanValue()) {
                return true;
            }
        }
        return false;
    }

    public String getShapeDescription(ItemStack itemStack) {
        Shape shape = ShapeCardItem.getShape(itemStack);
        boolean issolid = ShapeCardItem.isSolid(itemStack);
        return shape.getDescription() + " (" + (issolid ? "Solid" : "Hollow") + ")";
    }

    public String getShapeDimension(ItemStack itemStack) {
        Shape shape = ShapeCardItem.getShape(itemStack);
        boolean issolid = ShapeCardItem.isSolid(itemStack);
        return BlockPosTools.toString((BlockPos)ShapeCardItem.getDimension(itemStack));
    }

    public String getShapeOffset(ItemStack itemStack) {
        Shape shape = ShapeCardItem.getShape(itemStack);
        boolean issolid = ShapeCardItem.isSolid(itemStack);
        return BlockPosTools.toString((BlockPos)ShapeCardItem.getOffset(itemStack));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        Player player = context.getPlayer();
        if (world.isClientSide || player == null) return InteractionResult.SUCCESS;
        InteractionHand hand = context.getHand();
        BlockPos pos = context.getClickedPos();
        ItemStack stack = context.getItemInHand();
        int mode = ShapeCardItem.getMode(stack);
        if (mode == 0) {
            if (!player.isShiftKeyDown()) return InteractionResult.SUCCESS;
            if (world.getBlockEntity(pos) instanceof BuilderTileEntity) {
                ShapeCardItem.setCurrentBlock(stack, GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)pos));
                Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.GREEN) + "Now select the first corner"));
                ShapeCardItem.setMode(stack, 1);
                ShapeCardItem.setCorner1(stack, null);
                return InteractionResult.SUCCESS;
            } else {
                Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.RED) + "You can only do this on a builder!"));
            }
            return InteractionResult.SUCCESS;
        } else if (mode == 1) {
            GlobalPos currentBlock = ShapeCardItem.getCurrentBlock(stack);
            if (currentBlock == null) {
                Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.RED) + "There is no Builder selected!"));
                return InteractionResult.SUCCESS;
            } else if (!currentBlock.dimension().equals(world.dimension())) {
                Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.RED) + "The Builder is in another dimension!"));
                return InteractionResult.SUCCESS;
            } else if (currentBlock.pos().equals((Object)pos)) {
                Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.RED) + "Cleared area selection mode!"));
                ShapeCardItem.setMode(stack, 0);
                return InteractionResult.SUCCESS;
            } else {
                Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.GREEN) + "Now select the second corner"));
                ShapeCardItem.setMode(stack, 2);
                ShapeCardItem.setCorner1(stack, pos);
            }
            return InteractionResult.SUCCESS;
        } else {
            GlobalPos currentBlock = ShapeCardItem.getCurrentBlock(stack);
            if (currentBlock == null) {
                Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.RED) + "There is no Builder selected!"));
                return InteractionResult.SUCCESS;
            } else if (!currentBlock.dimension().equals(world.dimension())) {
                Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.RED) + "The Builder is in another dimension!"));
                return InteractionResult.SUCCESS;
            } else if (currentBlock.pos().equals((Object)pos)) {
                Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.RED) + "Cleared area selection mode!"));
                ShapeCardItem.setMode(stack, 0);
                return InteractionResult.SUCCESS;
            } else {
                BlockPos c1 = ShapeCardItem.getCorner1(stack);
                if (c1 == null) {
                    Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.RED) + "Cleared area selection mode!"));
                    ShapeCardItem.setMode(stack, 0);
                    return InteractionResult.SUCCESS;
                } else {
                    Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.GREEN) + "New settings copied to the shape card!"));
                    BlockPos center = new BlockPos((int)Math.ceil((float)(c1.getX() + pos.getX()) / 2.0f), (int)Math.ceil((float)(c1.getY() + pos.getY()) / 2.0f), (int)Math.ceil((float)(c1.getZ() + pos.getZ()) / 2.0f));
                    ShapeCardItem.setDimension(stack, Math.abs(c1.getX() - pos.getX()) + 1, Math.abs(c1.getY() - pos.getY()) + 1, Math.abs(c1.getZ() - pos.getZ()) + 1);
                    ShapeCardItem.setOffset(stack, center.getX() - currentBlock.pos().getX(), center.getY() - currentBlock.pos().getY(), center.getZ() - currentBlock.pos().getZ());
                    ShapeCardItem.setMode(stack, 0);
                    ShapeCardItem.setCorner1(stack, null);
                    ShapeCardItem.setShape(stack, Shape.SHAPE_BOX, true);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public Collection<DataComponentType<?>> getComponentsToPreserve() {
        return List.of((DataComponentType)BuilderModule.ITEM_SHAPECARD_DATA.get());
    }

    public static void setData(ItemStack card, int scanID) {
    }

    public static void setModifier(ItemStack card, ShapeModifier modifier) {
    }

    public static void setGhostMaterial(ItemStack card, ItemStack materialGhost) {
    }

    public static void setChildren(ItemStack card, ListTag list) {
    }

    public static void setDimension(ItemStack card, int x, int y, int z) {
        ShapeCardData data = (ShapeCardData)card.getOrDefault((DataComponentType)BuilderModule.ITEM_SHAPECARD_DATA.get(), (Object)ShapeCardData.DEFAULT);
        card.set((DataComponentType)BuilderModule.ITEM_SHAPECARD_DATA.get(), (Object)data.withDimension(new BlockPos(x, y, z)));
    }

    public static void setOffset(ItemStack card, int x, int y, int z) {
        ShapeCardData data = (ShapeCardData)card.getOrDefault((DataComponentType)BuilderModule.ITEM_SHAPECARD_DATA.get(), (Object)ShapeCardData.DEFAULT);
        card.set((DataComponentType)BuilderModule.ITEM_SHAPECARD_DATA.get(), (Object)data.withOffset(new BlockPos(x, y, z)));
    }

    public static void setCorner1(ItemStack card, BlockPos corner) {
        ShapeCardData data = (ShapeCardData)card.getOrDefault((DataComponentType)BuilderModule.ITEM_SHAPECARD_DATA.get(), (Object)ShapeCardData.DEFAULT);
        card.set((DataComponentType)BuilderModule.ITEM_SHAPECARD_DATA.get(), (Object)data.withCorner(corner));
    }

    public static BlockPos getCorner1(ItemStack card) {
        return ((ShapeCardData)card.getOrDefault((DataComponentType)BuilderModule.ITEM_SHAPECARD_DATA.get(), (Object)ShapeCardData.DEFAULT)).dimensions().corner1();
    }

    public static int getMode(ItemStack card) {
        GlobalPos block;
        int mode = ((ShapeCardData)card.getOrDefault((DataComponentType)BuilderModule.ITEM_SHAPECARD_DATA.get(), (Object)ShapeCardData.DEFAULT)).dimensions().mode();
        if (mode != 0 && (block = ShapeCardItem.getCurrentBlock(card)) == null) {
            return 0;
        }
        return mode;
    }

    public static void setMode(ItemStack card, int mode) {
        ShapeCardData data = (ShapeCardData)card.getOrDefault((DataComponentType)BuilderModule.ITEM_SHAPECARD_DATA.get(), (Object)ShapeCardData.DEFAULT);
        card.set((DataComponentType)BuilderModule.ITEM_SHAPECARD_DATA.get(), (Object)data.withMode(mode));
    }

    public static void setCurrentBlock(ItemStack card, GlobalPos c) {
        ShapeCardData data = (ShapeCardData)card.getOrDefault((DataComponentType)BuilderModule.ITEM_SHAPECARD_DATA.get(), (Object)ShapeCardData.DEFAULT);
        card.set((DataComponentType)BuilderModule.ITEM_SHAPECARD_DATA.get(), (Object)data.withSelected(c));
    }

    @Nullable
    private static GlobalPos getCurrentBlock(ItemStack card) {
        return ((ShapeCardData)card.getOrDefault((DataComponentType)BuilderModule.ITEM_SHAPECARD_DATA.get(), (Object)ShapeCardData.DEFAULT)).dimensions().selected();
    }

    public void appendHoverText(@Nonnull ItemStack itemStack, Item.TooltipContext context, @Nonnull List<Component> list, @Nonnull TooltipFlag flag) {
        super.appendHoverText(itemStack, context, list, flag);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(ResourceLocation.fromNamespaceAndPath((String)"rftoolsbuilder", (String)"shape_card"), itemStack, list, flag);
    }

    public static boolean isNormalShapeCard(ItemStack card) {
        ShapeCardType type = ShapeCardItem.getType(card);
        return type == ShapeCardType.CARD_SHAPE || type == ShapeCardType.CARD_PUMP_LIQUID;
    }

    public static ShapeCardType getType(ItemStack card) {
        if (card.getItem() instanceof ShapeCardItem) {
            return ((ShapeCardItem)card.getItem()).type;
        }
        if (card.getItem() == BuilderModule.SPACE_CHAMBER_CARD.get()) {
            return ShapeCardType.CARD_SPACE;
        }
        return ShapeCardType.CARD_UNKNOWN;
    }

    private static void addBlocks(Set<Block> blocks, Block block, TagKey<Block> tag, boolean tagMatching) {
        blocks.add(block);
        if (tagMatching && tag != null) {
            TagTools.getBlocksForTag(tag).forEach(b -> blocks.add((Block)b.value()));
        }
    }

    public static Set<Block> getVoidedBlocks(ItemStack stack) {
        HashSet<Block> blocks = new HashSet<Block>();
        boolean tagMatching = ShapeCardItem.isTagMatching(stack);
        if (ShapeCardItem.isVoiding(stack, "stone")) {
            ShapeCardItem.addBlocks(blocks, Blocks.STONE, (TagKey<Block>)Tags.Blocks.STONES, tagMatching);
        }
        if (ShapeCardItem.isVoiding(stack, "cobble")) {
            ShapeCardItem.addBlocks(blocks, Blocks.COBBLESTONE, (TagKey<Block>)Tags.Blocks.COBBLESTONES, tagMatching);
        }
        if (ShapeCardItem.isVoiding(stack, "dirt")) {
            ShapeCardItem.addBlocks(blocks, Blocks.DIRT, (TagKey<Block>)BlockTags.DIRT, tagMatching);
            ShapeCardItem.addBlocks(blocks, Blocks.GRASS_BLOCK, null, tagMatching);
        }
        if (ShapeCardItem.isVoiding(stack, "sand")) {
            ShapeCardItem.addBlocks(blocks, Blocks.SAND, (TagKey<Block>)Tags.Blocks.SANDS, tagMatching);
        }
        if (ShapeCardItem.isVoiding(stack, "gravel")) {
            ShapeCardItem.addBlocks(blocks, Blocks.GRAVEL, (TagKey<Block>)Tags.Blocks.GRAVELS, tagMatching);
        }
        if (ShapeCardItem.isVoiding(stack, "netherrack")) {
            ShapeCardItem.addBlocks(blocks, Blocks.NETHERRACK, (TagKey<Block>)Tags.Blocks.NETHERRACKS, tagMatching);
        }
        if (ShapeCardItem.isVoiding(stack, "endstone")) {
            ShapeCardItem.addBlocks(blocks, Blocks.END_STONE, (TagKey<Block>)Tags.Blocks.END_STONES, tagMatching);
        }
        return blocks;
    }

    public static boolean isTagMatching(ItemStack card) {
        return ((ShapeCardData)card.getOrDefault((DataComponentType)BuilderModule.ITEM_SHAPECARD_DATA.get(), (Object)ShapeCardData.DEFAULT)).tagMatching();
    }

    public static void setTagMatching(ItemStack card, boolean tagMatching) {
        ShapeCardData data = (ShapeCardData)card.getOrDefault((DataComponentType)BuilderModule.ITEM_SHAPECARD_DATA.get(), (Object)ShapeCardData.DEFAULT);
        card.set((DataComponentType)BuilderModule.ITEM_SHAPECARD_DATA.get(), (Object)data.withTagMatching(tagMatching));
    }

    public static boolean isVoiding(ItemStack card, String material) {
        return ((ShapeCardData)card.getOrDefault((DataComponentType)BuilderModule.ITEM_SHAPECARD_DATA.get(), (Object)ShapeCardData.DEFAULT)).voiding().contains(material);
    }

    public static void addVoiding(ItemStack card, String material) {
        ShapeCardData data = (ShapeCardData)card.getOrDefault((DataComponentType)BuilderModule.ITEM_SHAPECARD_DATA.get(), (Object)ShapeCardData.DEFAULT);
        card.set((DataComponentType)BuilderModule.ITEM_SHAPECARD_DATA.get(), (Object)data.addVoiding(material));
    }

    public static void clearVoiding(ItemStack card) {
        ShapeCardData data = (ShapeCardData)card.getOrDefault((DataComponentType)BuilderModule.ITEM_SHAPECARD_DATA.get(), (Object)ShapeCardData.DEFAULT);
        card.set((DataComponentType)BuilderModule.ITEM_SHAPECARD_DATA.get(), (Object)data.withVoiding(new HashSet<String>()));
    }

    public static Shape getShape(ItemStack card) {
        return ((ShapeCardData)card.getOrDefault((DataComponentType)BuilderModule.ITEM_SHAPECARD_DATA.get(), (Object)ShapeCardData.DEFAULT)).shape();
    }

    public static boolean isSolid(ItemStack card) {
        if (card.isEmpty()) {
            return true;
        }
        return ((ShapeCardData)card.getOrDefault((DataComponentType)BuilderModule.ITEM_SHAPECARD_DATA.get(), (Object)ShapeCardData.DEFAULT)).solid();
    }

    public static IFormula createCorrectFormula(CompoundTag tagCompound) {
        return null;
    }

    public static int getScanId(ItemStack stack) {
        return 0;
    }

    public static int getScanIdRecursive(ItemStack card) {
        Shape shape = ShapeCardItem.getShape(card);
        if (shape == Shape.SHAPE_COMPOSITION) {
            // empty if block
        }
        return 0;
    }

    public static int getFormulaCheckClient(ItemStack stack) {
        Check32 crc = new Check32();
        ShapeCardItem.getFormulaCheckClient(stack, crc);
        return crc.get();
    }

    public static void getFormulaCheckClient(ItemStack stack, Check32 crc) {
    }

    public static void getLocalChecksum(ItemStack card, Check32 crc) {
    }

    public static void setShape(ItemStack stack, Shape shape, boolean solid) {
        ShapeCardData data = (ShapeCardData)stack.getOrDefault((DataComponentType)BuilderModule.ITEM_SHAPECARD_DATA.get(), (Object)ShapeCardData.DEFAULT);
        stack.set((DataComponentType)BuilderModule.ITEM_SHAPECARD_DATA.get(), (Object)data.withShape(shape).withSolid(solid));
    }

    public static BlockPos getDimension(ItemStack stack) {
        return ((ShapeCardData)stack.getOrDefault((DataComponentType)BuilderModule.ITEM_SHAPECARD_DATA.get(), (Object)ShapeCardData.DEFAULT)).dimensions().dimension();
    }

    public static BlockPos getClampedDimension(ItemStack card, int maximum) {
        BlockPos dimension = ShapeCardItem.getDimension(card);
        return new BlockPos(ShapeCardItem.clampDimension(dimension.getX(), maximum), ShapeCardItem.clampDimension(dimension.getY(), maximum), ShapeCardItem.clampDimension(dimension.getZ(), maximum));
    }

    private static int clampDimension(int o, int maximum) {
        if (o > maximum) {
            o = maximum;
        } else if (o < 0) {
            o = 0;
        }
        return o;
    }

    public static BlockPos getOffset(ItemStack card) {
        return ((ShapeCardData)card.getOrDefault((DataComponentType)BuilderModule.ITEM_SHAPECARD_DATA.get(), (Object)ShapeCardData.DEFAULT)).dimensions().offset();
    }

    public static BlockPos getClampedOffset(ItemStack card, int maximum) {
        BlockPos offset = ShapeCardItem.getOffset(card);
        return new BlockPos(ShapeCardItem.clampOffset(offset.getX(), maximum), ShapeCardItem.clampOffset(offset.getY(), maximum), ShapeCardItem.clampOffset(offset.getZ(), maximum));
    }

    private static int clampOffset(int o, int maximum) {
        if (o < -maximum) {
            o = -maximum;
        } else if (o > maximum) {
            o = maximum;
        }
        return o;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (world.isClientSide) {
            GuiShapeCard.open(false);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public static BlockPos getMinCorner(BlockPos thisCoord, BlockPos dimension, BlockPos offset) {
        int xCoord = thisCoord.getX();
        int yCoord = thisCoord.getY();
        int zCoord = thisCoord.getZ();
        int dx = dimension.getX();
        int dy = dimension.getY();
        int dz = dimension.getZ();
        return new BlockPos(xCoord - dx / 2 + offset.getX(), yCoord - dy / 2 + offset.getY(), zCoord - dz / 2 + offset.getZ());
    }

    public static BlockPos getMaxCorner(BlockPos thisCoord, BlockPos dimension, BlockPos offset) {
        int dx = dimension.getX();
        int dy = dimension.getY();
        int dz = dimension.getZ();
        BlockPos minCorner = ShapeCardItem.getMinCorner(thisCoord, dimension, offset);
        return new BlockPos(minCorner.getX() + dx, minCorner.getY() + dy, minCorner.getZ() + dz);
    }

    public static boolean xInChunk(int x, ChunkPos chunk) {
        if (chunk == null) {
            return true;
        }
        return chunk.x == x >> 4;
    }

    public static boolean zInChunk(int z, ChunkPos chunk) {
        if (chunk == null) {
            return true;
        }
        return chunk.z == z >> 4;
    }

    private static void placeBlockIfPossible(Level worldObj, Map<BlockPos, BlockState> blocks, int maxSize, int x, int y, int z, BlockState state, boolean forquarry) {
        BlockPos c = new BlockPos(x, y, z);
        if (worldObj == null) {
            blocks.put(c, state);
            return;
        }
        if (forquarry) {
            if (worldObj.isEmptyBlock(c)) {
                return;
            }
            blocks.put(c, state);
        } else if (BuilderTileEntity.isEmptyOrReplacable(worldObj, c) && blocks.size() < maxSize) {
            blocks.put(c, state);
        }
    }

    public static int getRenderPositions(ItemStack stack, boolean solid, RLE positions, StatePalette statePalette, IFormula formula, int oy) {
        BlockPos dimension = ShapeCardItem.getDimension(stack);
        BlockPos clamped = new BlockPos(Math.min(dimension.getX(), 512), Math.min(dimension.getY(), 4096), Math.min(dimension.getZ(), 512));
        int dx = clamped.getX();
        int dy = clamped.getY();
        int dz = clamped.getZ();
        int cnt = 0;
        int y = oy - dy / 2;
        for (int ox = 0; ox < dx; ++ox) {
            int x = ox - dx / 2;
            for (int oz = 0; oz < dz; ++oz) {
                int z = oz - dz / 2;
                int v = 255;
                if (formula.isInside(x, y, z)) {
                    ++cnt;
                    BlockState lastState = formula.getLastState();
                    if (solid) {
                        if (ox == 0 || ox == dx - 1 || oy == 0 || oy == dy - 1 || oz == 0 || oz == dz - 1) {
                            v = statePalette.alloc(lastState, -1) + 1;
                        } else if (formula.isVisible(x, y, z)) {
                            v = statePalette.alloc(lastState, -1) + 1;
                        }
                    } else {
                        v = statePalette.alloc(lastState, -1) + 1;
                    }
                }
                positions.add(v);
            }
        }
        return cnt;
    }

    public static int getDataPositions(Level world, ItemStack stack, Shape shape, boolean solid, RLE positions, StatePalette statePalette) {
        BlockPos dimension = ShapeCardItem.getDimension(stack);
        BlockPos clamped = new BlockPos(Math.min(dimension.getX(), 512), Math.min(dimension.getY(), 4096), Math.min(dimension.getZ(), 512));
        IFormula formula = shape.getFormulaFactory().get();
        int dx = clamped.getX();
        int dy = clamped.getY();
        int dz = clamped.getZ();
        formula = formula.correctFormula(solid);
        int cnt = 0;
        for (int ox = 0; ox < dx; ++ox) {
            int x = ox - dx / 2;
            for (int oz = 0; oz < dz; ++oz) {
                int z = oz - dz / 2;
                for (int oy = 0; oy < dy; ++oy) {
                    int y = oy - dy / 2;
                    int v = 255;
                    if (formula.isInside(x, y, z)) {
                        ++cnt;
                        BlockState lastState = formula.getLastState();
                        if (lastState == null) {
                            lastState = Blocks.STONE.defaultBlockState();
                        }
                        v = statePalette.alloc(lastState, 0) + 1;
                    }
                    positions.add(v);
                }
            }
        }
        return cnt;
    }

    public static void composeFormula(ItemStack shapeCard, IFormula formula, Level worldObj, BlockPos thisCoord, BlockPos dimension, BlockPos offset, Map<BlockPos, BlockState> blocks, int maxSize, boolean solid, boolean forquarry, ChunkPos chunk) {
        int xCoord = thisCoord.getX();
        int yCoord = thisCoord.getY();
        int zCoord = thisCoord.getZ();
        int dx = dimension.getX();
        int dy = dimension.getY();
        int dz = dimension.getZ();
        BlockPos tl = new BlockPos(xCoord - dx / 2 + offset.getX(), yCoord - dy / 2 + offset.getY(), zCoord - dz / 2 + offset.getZ());
        formula = formula.correctFormula(solid);
        formula.setup(worldObj, thisCoord, dimension, offset, shapeCard);
        for (int ox = 0; ox < dx; ++ox) {
            int x = tl.getX() + ox;
            if (!ShapeCardItem.xInChunk(x, chunk)) continue;
            for (int oz = 0; oz < dz; ++oz) {
                int z = tl.getZ() + oz;
                if (!ShapeCardItem.zInChunk(z, chunk)) continue;
                for (int oy = 0; oy < dy; ++oy) {
                    int y = tl.getY() + oy;
                    if (!formula.isInside(x, y, z)) continue;
                    ShapeCardItem.placeBlockIfPossible(worldObj, blocks, maxSize, x, y, z, formula.getLastState(), forquarry);
                }
            }
        }
    }

    private static boolean validFile(Player player, String filename) {
        if (filename.contains("\\") || filename.contains("/") || filename.contains(":")) {
            player.displayClientMessage((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.RED) + "Invalid filename '" + filename + "'! Cannot be a path!")), false);
            return false;
        }
        return true;
    }

    public static void save(Player player, ItemStack card, String filename) {
        if (!ShapeCardItem.validFile(player, filename)) {
            return;
        }
        Shape shape = ShapeCardItem.getShape(card);
        boolean solid = ShapeCardItem.isSolid(card);
        BlockPos offset = ShapeCardItem.getOffset(card);
        BlockPos dimension = ShapeCardItem.getDimension(card);
        RLE positions = new RLE();
        StatePalette statePalette = new StatePalette();
        int cnt = ShapeCardItem.getDataPositions(player.getCommandSenderWorld(), card, shape, solid, positions, statePalette);
        byte[] data = positions.getData();
        File dataDir = new File("rftoolsscans");
        dataDir.mkdirs();
        File file = new File(dataDir, filename);
        try (PrintWriter writer = new PrintWriter(new FileOutputStream(file));){
            writer.println("SHAPE");
            writer.println("DIM:" + dimension.getX() + "," + dimension.getY() + "," + dimension.getZ());
            writer.println("OFF:" + offset.getX() + "," + offset.getY() + "," + offset.getZ());
            for (BlockState state : statePalette.getPalette()) {
                String r = Tools.getId((BlockState)state).toString();
                writer.println(r);
            }
            writer.println("DATA");
            byte[] encoded = Base64.getEncoder().encode(data);
            writer.write(new String(encoded));
        }
        catch (FileNotFoundException e) {
            player.displayClientMessage((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.RED) + "Cannot write to file '" + filename + "'!")), false);
            return;
        }
        player.displayClientMessage((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.GREEN) + "Saved shape to file '" + file.getPath() + "'")), false);
    }

    public static void load(Player player, ItemStack card, String filename) {
        if (!ShapeCardItem.validFile(player, filename)) {
            return;
        }
        Shape shape = ShapeCardItem.getShape(card);
        if (shape != Shape.SHAPE_SCAN) {
            player.displayClientMessage((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.RED) + "To load a file into this card you need a linked 'scan' type card!")), false);
            return;
        }
        CompoundTag compound = new CompoundTag();
        int scanId = compound.getInt("scanid");
        if (scanId == 0) {
            player.displayClientMessage((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.RED) + "This card is not linked to scan data!")), false);
            return;
        }
        File dataDir = new File("rftoolsscans");
        dataDir.mkdirs();
        File file = new File(dataDir, filename);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String s = reader.readLine();
            if (!"SHAPE".equals(s)) {
                player.displayClientMessage((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.RED) + "This does not appear to be a valid shapecard file!")), false);
                return;
            }
            s = reader.readLine();
            if (!s.startsWith("DIM:")) {
                player.displayClientMessage((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.RED) + "This does not appear to be a valid shapecard file!")), false);
                return;
            }
            BlockPos dim = ShapeCardItem.parse(s.substring(4));
            s = reader.readLine();
            if (!s.startsWith("OFF:")) {
                player.displayClientMessage((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.RED) + "This does not appear to be a valid shapecard file!")), false);
                return;
            }
            BlockPos off = ShapeCardItem.parse(s.substring(4));
            s = reader.readLine();
            StatePalette statePalette = new StatePalette();
            while (!"DATA".equals(s)) {
                String[] split = StringUtils.split((String)s, (char)'@');
                Block block = Tools.getBlock((ResourceLocation)ResourceLocation.parse((String)split[0]));
                int meta = Integer.parseInt(split[1]);
                if (block == null) {
                    player.displayClientMessage((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.YELLOW) + "Could not find block '" + split[0] + "'!")), false);
                    block = Blocks.STONE;
                    meta = 0;
                }
                statePalette.add(block.defaultBlockState());
                s = reader.readLine();
            }
            s = reader.readLine();
            byte[] decoded = Base64.getDecoder().decode(s.getBytes());
            ShapeCardItem.setDataFromFile(scanId, card, dim, off, decoded, statePalette);
        }
        catch (IOException e) {
            player.displayClientMessage((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.RED) + "Cannot read from file '" + filename + "'!")), false);
            return;
        }
        catch (NullPointerException e) {
            player.displayClientMessage((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.RED) + "File '" + filename + "' is too short!")), false);
            return;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            player.displayClientMessage((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.RED) + "File '" + filename + "' contains invalid entries!")), false);
            return;
        }
        player.displayClientMessage((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.GREEN) + "Loaded shape from file '" + file.getPath() + "'")), false);
    }

    private static void setDataFromFile(int scanId, ItemStack card, BlockPos dimension, BlockPos offset, byte[] data, StatePalette palette) {
    }

    private static BlockPos parse(String s) {
        String[] split = StringUtils.split((String)s, (char)',');
        return new BlockPos(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
    }
}

