/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.blocks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.ItemInfusable;
import mcjty.lib.api.power.ItemEnergy;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ISerializer;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.setup.Registration;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsbuilder.compat.RFToolsBuilderTOPDriver;
import mcjty.rftoolsbuilder.modules.mover.MoverConfiguration;
import mcjty.rftoolsbuilder.modules.mover.MoverModule;
import mcjty.rftoolsbuilder.modules.mover.blocks.MoverTileEntity;
import mcjty.rftoolsbuilder.modules.mover.client.GuiMoverController;
import mcjty.rftoolsbuilder.modules.mover.data.MoverControllerData;
import mcjty.rftoolsbuilder.modules.mover.items.VehicleCard;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentType;
import org.apache.commons.lang3.tuple.Pair;

public class MoverControllerTileEntity
extends GenericTileEntity {
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)MoverConfiguration.MAXENERGY.get()).intValue(), (long)((Integer)MoverConfiguration.RECEIVEPERTICK.get()).intValue());
    @Cap(type=CapType.ENERGY)
    private static final Function<MoverControllerTileEntity, GenericEnergyStorage> ENERGY_CAP = tile -> tile.energyStorage;
    @Cap(type=CapType.CONTAINER)
    private static final Function<MoverControllerTileEntity, MenuProvider> SCREEN_CAP = tile -> new DefaultContainerProvider("Mover").containerSupplier(DefaultContainerProvider.empty(MoverModule.CONTAINER_MOVER_CONTROLLER, (GenericTileEntity)tile)).energyHandler(() -> tile.energyStorage).data(MoverModule.MOVER_CONTROLLER_DATA, MoverControllerData.STREAM_CODEC, MoverControllerData.CODEC).setupSync((GenericTileEntity)tile);
    private final DefaultInfusable infusable = new DefaultInfusable((BlockEntity)this);
    @Cap(type=CapType.INFUSABLE)
    private static final Function<MoverControllerTileEntity, DefaultInfusable> INFUSABLE_CAP = tile -> tile.infusable;
    public static final int MAXSCAN = 128;
    @GuiValue
    public static final Value<?, String> VALUE_SELECTED_VEHICLE = Value.create((String)"selectedVehicle", (Type)Type.STRING, MoverControllerTileEntity::getSelectedVehicle, MoverControllerTileEntity::setSelectedVehicle);
    private String selectedVehicle;
    public static final Key<BlockPos> SELECTED_NODE = new Key("node", Type.BLOCKPOS);
    public static final Key<String> SELECTED_VEHICLE = new Key("vehicle", Type.STRING);
    public static final Key<String> SELECTED_DESTINATION = new Key("destination", Type.STRING);
    @ServerCommand
    public static final Command<?> CMD_SCAN = Command.create((String)"scan", (te, player, params) -> te.doScan());
    @ServerCommand
    public static final Command<?> CMD_MOVE = Command.create((String)"move", (te, player, params) -> te.startMove((BlockPos)params.get(SELECTED_NODE), (String)params.get(SELECTED_VEHICLE), (String)params.get(SELECTED_DESTINATION)));
    @ServerCommand
    public static final Command<?> CMD_SELECTNODE = Command.create((String)"selectNode", (te, player, params) -> te.selectNode((BlockPos)params.get(SELECTED_NODE)));
    @ServerCommand(type=String.class)
    public static final ListCommand<?, ?> CMD_GETVEHICLES = ListCommand.create((String)"rftoolsbuilder.movercontroller.getVehicles", (te, player, params) -> te.getVehicles(), (te, player, params, list) -> GuiMoverController.setVehiclesFromServer(list));
    @ServerCommand(type=Pair.class, serializer=NodePairSerializer.class)
    public static final ListCommand<?, ?> CMD_GETNODES = ListCommand.create((String)"rftoolsbuilder.movercontroller.getNodes", (te, player, params) -> te.getNodes(), (te, player, params, list) -> GuiMoverController.setNodesFromServer(list));

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(MoverControllerTileEntity::new).topDriver((TOPDriver)RFToolsBuilderTOPDriver.DRIVER).infusable().manualEntry(ManualHelper.create((String)"rftoolsbuilder:todo")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbuilder.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()}));
    }

    public MoverControllerTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MoverModule.MOVER_CONTROLLER.be().get(), pos, state);
    }

    private void selectNode(BlockPos pos) {
        MoverTileEntity mover;
        ItemStack card;
        BlockEntity blockEntity = this.level.getBlockEntity(pos);
        this.selectedVehicle = blockEntity instanceof MoverTileEntity ? ((card = (mover = (MoverTileEntity)blockEntity).getCard()).isEmpty() ? null : VehicleCard.getVehicleName(card)) : null;
    }

    public void onDataChanged(AttachmentType<?> type, Object oldData, Object newData) {
        if (type == MoverModule.MOVER_CONTROLLER_DATA.get()) {
            this.onDataChanged((MoverControllerData)oldData, (MoverControllerData)newData);
        }
    }

    private void onDataChanged(MoverControllerData oldData, MoverControllerData newData) {
        if (oldData.offsetX() != newData.offsetX() || oldData.offsetY() != newData.offsetY() || oldData.offsetZ() != newData.offsetZ()) {
            this.onOffsetChanged(newData.offsetX(), newData.offsetY(), newData.offsetZ());
        }
    }

    private void onOffsetChanged(int x, int y, int z) {
        this.traverseDepthFirst((pos, mover) -> {
            mover.setOffset(x, y, z);
            return null;
        });
    }

    public String getSelectedVehicle() {
        return this.selectedVehicle;
    }

    public void setSelectedVehicle(String vehicle) {
        this.selectedVehicle = vehicle;
        if (this.level.isClientSide) {
            GuiMoverController.setSelectedVehicle(vehicle);
        }
    }

    @Nullable
    public <T> T traverseBreadthFirst(BiFunction<BlockPos, MoverTileEntity, T> function) {
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            BlockPos moverPos = this.worldPosition.relative(direction);
            BlockEntity blockEntity = this.level.getBlockEntity(moverPos);
            if (!(blockEntity instanceof MoverTileEntity)) continue;
            MoverTileEntity mover = (MoverTileEntity)blockEntity;
            return mover.traverseBreadthFirst(function);
        }
        return null;
    }

    @Nullable
    private <T> T traverseDepthFirst(BiFunction<BlockPos, MoverTileEntity, T> function) {
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            BlockPos moverPos = this.worldPosition.relative(direction);
            BlockEntity blockEntity = this.level.getBlockEntity(moverPos);
            if (!(blockEntity instanceof MoverTileEntity)) continue;
            MoverTileEntity mover = (MoverTileEntity)blockEntity;
            return mover.traverseDepthFirst(function);
        }
        return null;
    }

    public boolean hasEnoughPower() {
        return this.energyStorage.getEnergyStored() >= this.getPowerPerMove();
    }

    private Integer getPowerPerMove() {
        int power = (Integer)MoverConfiguration.RF_PER_MOVE.get();
        power = (int)((float)power * (2.0f - this.infusable.getInfusedFactor()) / 2.0f);
        return power;
    }

    public void setupMovement(String moverName, String vehicle) {
        if (this.energyStorage.getEnergyStored() < this.getPowerPerMove()) {
            return;
        }
        MoverTileEntity destinationMover = this.findMover(moverName);
        if (destinationMover != null) {
            if (vehicle == null || vehicle.trim().isEmpty()) {
                vehicle = this.traverseBreadthFirst((p, mover) -> {
                    ItemStack card = mover.getCard();
                    if (!card.isEmpty()) {
                        return VehicleCard.getVehicleName(card);
                    }
                    return null;
                });
            }
            if (vehicle != null) {
                this.energyStorage.consumeEnergy((long)this.getPowerPerMove().intValue());
                this.startMove(destinationMover.getBlockPos(), vehicle, destinationMover.getName());
            }
        }
    }

    private void startMove(BlockPos destination, String vehicle, String destinationName) {
        MoverTileEntity moverContainingVehicle;
        if (vehicle.contains(" -> ")) {
            vehicle = vehicle.substring(0, vehicle.indexOf(" -> "));
        }
        if ((moverContainingVehicle = this.findVehicle(vehicle)) != null) {
            ItemStack card = moverContainingVehicle.getCard();
            VehicleCard.setDesiredDestination(card, destination, destinationName);
        }
    }

    @Nullable
    private MoverTileEntity findMover(String moverName) {
        return this.traverseDepthFirst((p, mover) -> {
            if (Objects.equals(moverName, mover.getName())) {
                return mover;
            }
            return null;
        });
    }

    @Nullable
    public MoverTileEntity findVehicle(String vehicle) {
        return this.traverseDepthFirst((p, mover) -> {
            ItemStack card = mover.getCard();
            String name = VehicleCard.getVehicleName(card);
            if (Objects.equals(name, vehicle)) {
                return mover;
            }
            return null;
        });
    }

    private void doScan() {
        this.setChanged();
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            BlockPos moverPos = this.worldPosition.relative(direction);
            BlockEntity blockEntity = this.level.getBlockEntity(moverPos);
            if (!(blockEntity instanceof MoverTileEntity)) continue;
            MoverTileEntity mover = (MoverTileEntity)blockEntity;
            HashSet<BlockPos> alreadyHandled = new HashSet<BlockPos>();
            alreadyHandled.add(moverPos);
            this.doScan(moverPos, mover, alreadyHandled);
            return;
        }
    }

    private void doScan(BlockPos moverPos, MoverTileEntity mover, Set<BlockPos> alreadyHandled) {
        mover.clearNetwork();
        mover.setController(this);
        block0: for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            if (!mover.canConnect(direction)) continue;
            for (int distance = 1; distance <= 128; ++distance) {
                BlockPos destPos = moverPos.relative(direction, distance);
                BlockEntity blockEntity = this.level.getBlockEntity(destPos);
                if (!(blockEntity instanceof MoverTileEntity)) continue;
                MoverTileEntity destMover = (MoverTileEntity)blockEntity;
                mover.addConnection(direction, destPos);
                if (alreadyHandled.contains(destPos)) continue block0;
                alreadyHandled.add(destPos);
                this.doScan(destPos, destMover, alreadyHandled);
                continue block0;
            }
        }
    }

    public List<String> getMovers() {
        ArrayList<String> movers = new ArrayList<String>();
        this.traverseDepthFirst((p, mover) -> {
            movers.add(mover.getName());
            return null;
        });
        return movers;
    }

    private List<String> getVehicles() {
        ArrayList<String> vehicles = new ArrayList<String>();
        this.traverseDepthFirst((p, mover) -> {
            ItemStack card = mover.getCard();
            if (!card.isEmpty()) {
                Object name = VehicleCard.getVehicleName(card);
                BlockPos destination = VehicleCard.getDesiredDestination(card);
                String destinationName = VehicleCard.getDesiredDestinationName(card);
                if (destination != null) {
                    name = (String)name + " -> " + destinationName;
                }
                vehicles.add((String)name);
            }
            return null;
        });
        return vehicles;
    }

    private List<Pair<BlockPos, String>> getNodes() {
        ArrayList<Pair<BlockPos, String>> nodeNames = new ArrayList<Pair<BlockPos, String>>();
        this.traverseDepthFirst((p, mover) -> {
            Object name = mover.getName();
            if (name == null || ((String)name).trim().isEmpty()) {
                name = p.getX() + "," + p.getY() + "," + p.getZ();
            }
            nodeNames.add(Pair.of((Object)p, (Object)name));
            return null;
        });
        return nodeNames;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.energyStorage.save(tag, "energy", provider);
        this.infusable.save(tag, "infusable");
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.energyStorage.load(tag, "energy", provider);
        this.infusable.load(tag, "infusable");
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.energyStorage.applyImplicitComponents((ItemEnergy)input.get((Supplier)Registration.ITEM_ENERGY));
        this.infusable.applyImplicitComponents((ItemInfusable)input.get((Supplier)Registration.ITEM_INFUSABLE));
        MoverControllerData moverControllerData = (MoverControllerData)input.get(MoverModule.ITEM_MOVER_CONTROLLER_DATA);
        if (moverControllerData != null) {
            this.setData((Supplier)MoverModule.MOVER_CONTROLLER_DATA, moverControllerData);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        this.energyStorage.collectImplicitComponents(builder);
        this.infusable.collectImplicitComponents(builder);
        builder.set(MoverModule.ITEM_MOVER_CONTROLLER_DATA, (Object)((MoverControllerData)this.getData((Supplier)MoverModule.MOVER_CONTROLLER_DATA)));
    }

    public static class NodePairSerializer
    implements ISerializer<Pair<BlockPos, String>> {
        public Function<RegistryFriendlyByteBuf, Pair<BlockPos, String>> getDeserializer() {
            return buf -> Pair.of((Object)buf.readBlockPos(), (Object)buf.readUtf(Short.MAX_VALUE));
        }

        public BiConsumer<RegistryFriendlyByteBuf, Pair<BlockPos, String>> getSerializer() {
            return (buf, pair) -> {
                buf.writeBlockPos((BlockPos)pair.getLeft());
                buf.writeUtf((String)pair.getRight());
            };
        }
    }
}

