/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.shapes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.IdMap;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class StatePalette {
    private List<BlockState> palette = new ArrayList<BlockState>();
    private Map<BlockState, Integer> paletteIndex = new HashMap<BlockState, Integer>();
    public static final StreamCodec<RegistryFriendlyByteBuf, StatePalette> OPTIONAL_STREAM_CODEC = StreamCodec.of((buf, palette) -> {
        if (palette == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeVarInt(palette.palette.size());
            for (BlockState state : palette.palette) {
                ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY).encode(buf, (Object)state);
            }
        }
    }, buf -> {
        if (!buf.readBoolean()) {
            return null;
        }
        StatePalette palette = new StatePalette();
        int size = buf.readVarInt();
        for (int i = 0; i < size; ++i) {
            int index = buf.readVarInt();
            BlockState state = (BlockState)ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY).decode(buf);
            palette.palette.add(state);
            palette.paletteIndex.put(state, palette.palette.size());
        }
        return palette;
    });

    public int alloc(BlockState state, int def) {
        if (state == null) {
            return def;
        }
        Integer index = this.paletteIndex.get(state);
        if (index != null) {
            return index;
        }
        int idx = this.palette.size();
        if (idx > 253) {
            return 0;
        }
        this.palette.add(state);
        this.paletteIndex.put(state, idx);
        return idx;
    }

    public void add(BlockState state) {
        this.paletteIndex.put(state, this.palette.size());
        this.palette.add(state);
    }

    public List<BlockState> getPalette() {
        return this.palette;
    }
}

