/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.container;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class InventoryLocator {
    private BlockPos inventoryCoordinate = null;
    private Direction inventorySide = null;

    @Nonnull
    private IItemHandler getItemHandlerAtDirection(Level worldObj, BlockPos thisCoordinate, Direction direction) {
        if (direction == null) {
            if (this.inventoryCoordinate != null) {
                return this.getItemHandlerAtCoordinate(worldObj, this.inventoryCoordinate, this.inventorySide);
            }
            return null;
        }
        if (worldObj.getCapability(Capabilities.ItemHandler.BLOCK, thisCoordinate, (Object)direction.getOpposite()) != null) {
            this.inventoryCoordinate = thisCoordinate.relative(direction);
            this.inventorySide = direction.getOpposite();
            return this.getItemHandlerAtCoordinate(worldObj, this.inventoryCoordinate, this.inventorySide);
        }
        return null;
    }

    @Nullable
    private IItemHandler getItemHandlerAtCoordinate(Level worldObj, BlockPos c, Direction direction) {
        return (IItemHandler)worldObj.getCapability(Capabilities.ItemHandler.BLOCK, c, (Object)direction);
    }

    public void ejectStack(Level worldObj, BlockPos pos, ItemStack stack, BlockPos thisCoordinate, Direction[] directions) {
        for (Direction dir : directions) {
            if (stack.isEmpty()) break;
            IItemHandler itemHandler = this.getItemHandlerAtDirection(worldObj, thisCoordinate, dir);
            if (itemHandler == null) continue;
            stack = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
        }
        if (!stack.isEmpty()) {
            ItemEntity entityItem = new ItemEntity(worldObj, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack);
            worldObj.addFreshEntity((Entity)entityItem);
        }
    }

    public Direction getInventorySide() {
        return this.inventorySide;
    }
}

