/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import mcjty.rftoolsutility.modules.screen.ScreenModule;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenBlock;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.Lazy;

public class ScreenControllerTileEntity
extends TickingTileEntity {
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(0).playerSlots(10, 70));
    public static final String COMPONENT_NAME = "screen_controller";
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)ScreenConfiguration.CONTROLLER_MAXENERGY.get()).intValue(), (long)((Integer)ScreenConfiguration.CONTROLLER_RECEIVEPERTICK.get()).intValue());
    @Cap(type=CapType.ENERGY)
    private static final Function<ScreenControllerTileEntity, GenericEnergyStorage> ENERGY_CAP = tile -> tile.energyStorage;
    private final IInfusable infusable = new DefaultInfusable((BlockEntity)this);
    @Cap(type=CapType.INFUSABLE)
    private static final Function<ScreenControllerTileEntity, IInfusable> INFUSABLE_CAP = tile -> tile.infusable;
    @Cap(type=CapType.CONTAINER)
    private static final Function<ScreenControllerTileEntity, MenuProvider> screenHandler = be -> new DefaultContainerProvider("Screen Controller").containerSupplier(DefaultContainerProvider.container(ScreenModule.CONTAINER_SCREEN_CONTROLLER, CONTAINER_FACTORY, (GenericTileEntity)be)).energyHandler(() -> be.energyStorage).setupSync((GenericTileEntity)be);
    private List<BlockPos> connectedScreens = new ArrayList<BlockPos>();
    private int tickCounter = 20;
    @ServerCommand
    public static final Command<?> CMD_SCAN = Command.create((String)"scan", (te, player, params) -> te.scan());
    @ServerCommand
    public static final Command<?> CMD_DETACH = Command.create((String)"detach", (te, player, params) -> te.detach());

    public ScreenControllerTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ScreenModule.SCREEN_CONTROLLER.be().get(), pos, state);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        int[] xes = tag.getIntArray("screensx");
        int[] yes = tag.getIntArray("screensy");
        int[] zes = tag.getIntArray("screensz");
        this.connectedScreens.clear();
        for (int i = 0; i < xes.length; ++i) {
            this.connectedScreens.add(new BlockPos(xes[i], yes[i], zes[i]));
        }
        this.energyStorage.setEnergy(tag.getLong("Energy"));
    }

    public void saveAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        int[] xes = new int[this.connectedScreens.size()];
        int[] yes = new int[this.connectedScreens.size()];
        int[] zes = new int[this.connectedScreens.size()];
        for (int i = 0; i < this.connectedScreens.size(); ++i) {
            BlockPos c = this.connectedScreens.get(i);
            xes[i] = c.getX();
            yes[i] = c.getY();
            zes[i] = c.getZ();
        }
        tag.putIntArray("screensx", xes);
        tag.putIntArray("screensy", yes);
        tag.putIntArray("screensz", zes);
        tag.putLong("Energy", this.energyStorage.getEnergy());
    }

    protected void tickServer() {
        long rf;
        --this.tickCounter;
        if (this.tickCounter > 0) {
            return;
        }
        this.tickCounter = 20;
        long rememberRf = rf = this.energyStorage.getEnergy();
        boolean fixesAreNeeded = false;
        for (BlockPos c : this.connectedScreens) {
            BlockEntity te = this.level.getBlockEntity(c);
            if (te instanceof ScreenTileEntity) {
                ScreenTileEntity screen = (ScreenTileEntity)te;
                int rfModule = screen.getTotalRfPerTick() * 20;
                if ((long)rfModule > rf) {
                    screen.setPower(false);
                    continue;
                }
                rf -= (long)rfModule;
                screen.setPower(true);
                continue;
            }
            fixesAreNeeded = true;
        }
        if (rf < rememberRf) {
            this.energyStorage.consumeEnergy(rememberRf - rf);
        }
        if (fixesAreNeeded) {
            ArrayList<BlockPos> newScreens = new ArrayList<BlockPos>();
            for (BlockPos c : this.connectedScreens) {
                BlockEntity te = this.level.getBlockEntity(c);
                if (!(te instanceof ScreenTileEntity)) continue;
                newScreens.add(c);
            }
            this.connectedScreens = newScreens;
            this.setChanged();
        }
    }

    private void scan() {
        this.detach();
        float factor = this.infusable.getInfusedFactor();
        int radius = 32 + (int)(factor * 32.0f);
        int xCoord = this.getBlockPos().getX();
        int yCoord = this.getBlockPos().getY();
        int zCoord = this.getBlockPos().getZ();
        for (int y = yCoord - radius; y <= yCoord + radius; ++y) {
            if (y < this.level.getMinBuildHeight() || y >= this.level.getMaxBuildHeight()) continue;
            for (int x = xCoord - radius; x <= xCoord + radius; ++x) {
                for (int z = zCoord - radius; z <= zCoord + radius; ++z) {
                    ScreenTileEntity ste;
                    BlockEntity te;
                    BlockPos spos = new BlockPos(x, y, z);
                    if (!(this.level.getBlockState(spos).getBlock() instanceof ScreenBlock) || !((te = this.level.getBlockEntity(spos)) instanceof ScreenTileEntity) || (ste = (ScreenTileEntity)te).isConnected() || !ste.isControllerNeeded()) continue;
                    this.connectedScreens.add(spos);
                    ste.setConnected(true);
                }
            }
        }
        this.setChanged();
    }

    public void detach() {
        for (BlockPos c : this.connectedScreens) {
            BlockEntity te = this.level.getBlockEntity(c);
            if (!(te instanceof ScreenTileEntity)) continue;
            ScreenTileEntity screen = (ScreenTileEntity)te;
            screen.setPower(false);
            screen.setConnected(false);
        }
        this.connectedScreens.clear();
        this.setChanged();
    }

    public List<BlockPos> getConnectedScreens() {
        return this.connectedScreens;
    }
}

