/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.items.modules;

import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.crafting.IComponentsToPreserve;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.ModuleTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.screens.BarMode;
import mcjty.rftoolsbase.api.screens.FormatStyle;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleGuiBuilder;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.TextAlign;
import mcjty.rftoolsbase.tools.GenericModuleItem;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import mcjty.rftoolsutility.modules.screen.ScreenModule;
import mcjty.rftoolsutility.modules.screen.modules.EnergyBarScreenModule;
import mcjty.rftoolsutility.modules.screen.modulesclient.EnergyBarClientScreenModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class EnergyModuleItem
extends GenericModuleItem
implements IComponentsToPreserve {
    public EnergyModuleItem() {
        super(RFToolsUtility.setup.defaultProperties().stacksTo(1).durability(1));
    }

    public Codec<? extends IScreenModule<?, ?>> codec() {
        return EnergyBarScreenModule.CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, ? extends IScreenModule<?, ?>> streamCodec() {
        return EnergyBarScreenModule.STREAM_CODEC;
    }

    public DataComponentType<? extends IScreenModule<?, ?>> componentType() {
        return (DataComponentType)ScreenModule.MODULE_ENERGY_BAR_DATA.get();
    }

    protected int getUses(ItemStack stack) {
        return (Integer)ScreenConfiguration.ENERGY_RFPERTICK.get();
    }

    protected boolean hasGoldMessage(ItemStack stack) {
        return !BlockPosTools.isValid((BlockPos)EnergyModuleItem.data(stack).getPos().pos());
    }

    protected String getInfoString(ItemStack stack) {
        EnergyBarScreenModule data = EnergyModuleItem.data(stack);
        return ModuleTools.getTargetString((String)data.getMonitor(), (GlobalPos)data.getPos());
    }

    public IScreenModule<?, ?> createServerScreenModule() {
        return EnergyBarScreenModule.DEFAULT;
    }

    public IClientScreenModule<?> createClientScreenModule() {
        return new EnergyBarClientScreenModule();
    }

    public String getModuleName() {
        return "RF";
    }

    public static EnergyBarScreenModule data(ItemStack stack) {
        EnergyBarScreenModule data = (EnergyBarScreenModule)stack.get(ScreenModule.MODULE_ENERGY_BAR_DATA);
        if (data == null) {
            data = EnergyBarScreenModule.DEFAULT;
        }
        return data;
    }

    public static void data(ItemStack stack, Function<EnergyBarScreenModule, EnergyBarScreenModule> setter) {
        EnergyBarScreenModule data = EnergyModuleItem.data(stack);
        data = setter.apply(data);
        stack.set(ScreenModule.MODULE_ENERGY_BAR_DATA, (Object)data);
    }

    public void createGui(IModuleGuiBuilder guiBuilder) {
        guiBuilder.label("Label:").text((stack, s) -> EnergyModuleItem.data(stack, d -> d.withLine((String)s)), stack -> EnergyModuleItem.data(stack).getLine(), new String[]{"Label text"}).color((stack, c) -> EnergyModuleItem.data(stack, d -> d.withColor((int)c)), stack -> EnergyModuleItem.data(stack).getColor(), new String[]{"Color for the label"}).nl().label("RF+:").color((stack, c) -> EnergyModuleItem.data(stack, d -> d.withPosColor((int)c)), stack -> EnergyModuleItem.data(stack).getPosColor(), new String[]{"Color for the RF text"}).label("RF-:").color((stack, c) -> EnergyModuleItem.data(stack, d -> d.withNegColor((int)c)), stack -> EnergyModuleItem.data(stack).getNegColor(), new String[]{"Color for the negative", "RF/tick ratio"}).nl().toggleNegative((stack, b) -> EnergyModuleItem.data(stack, d -> d.withHideBar((boolean)b)), stack -> EnergyModuleItem.data(stack).isHideBar(), "Bar", new String[]{"Toggle visibility of the", "energy bar"}).mode((stack, m) -> EnergyModuleItem.data(stack, d -> d.withBarMode((BarMode)m)), stack -> EnergyModuleItem.data(stack).getBarMode(), "RF").format((stack, f) -> EnergyModuleItem.data(stack, d -> d.withFormat((FormatStyle)f)), stack -> EnergyModuleItem.data(stack).getFormat()).nl().choices((stack, c) -> EnergyModuleItem.data(stack, d -> d.withAlign(TextAlign.get((String)c))), stack -> EnergyModuleItem.data(stack).getAlign().getSerializedName(), "Label alignment", new String[]{"Left", "Center", "Right"}).nl().label("Block:").block(stack -> EnergyModuleItem.data(stack).getPos(), stack -> EnergyModuleItem.data(stack).getMonitor()).nl();
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction facing = context.getClickedFace();
        Player player = context.getPlayer();
        BlockEntity te = world.getBlockEntity(pos);
        EnergyBarScreenModule data = EnergyModuleItem.data(stack);
        if (EnergyTools.isEnergyTE((BlockEntity)te, (Direction)facing)) {
            data = data.withPos(GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)pos));
            data = data.withSide(facing);
            String name = "<invalid>";
            if (!world.getBlockState(pos).isAir()) {
                name = Tools.getReadableName((Level)world, (BlockPos)pos);
            }
            data = data.withMonitor(name);
            if (world.isClientSide) {
                Logging.message((Player)player, (String)("Energy module is set to block '" + name + "'"));
            }
        } else {
            data = data.withPos(GlobalPos.of((ResourceKey)Level.OVERWORLD, (BlockPos)BlockPosTools.INVALID));
            data = data.withMonitor("");
            if (world.isClientSide) {
                Logging.message((Player)player, (String)"Energy module is cleared");
            }
        }
        stack.set(ScreenModule.MODULE_ENERGY_BAR_DATA, (Object)data);
        return InteractionResult.SUCCESS;
    }

    public Collection<DataComponentType<?>> getComponentsToPreserve() {
        return List.of((DataComponentType)ScreenModule.MODULE_ENERGY_BAR_DATA.get());
    }
}

