/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter;

import java.util.concurrent.atomic.AtomicInteger;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.TeleportationTools;
import mcjty.rftoolsutility.modules.teleporter.ClientCommandHandler;
import mcjty.rftoolsutility.modules.teleporter.TeleporterModule;
import mcjty.rftoolsutility.modules.teleporter.data.ChargedPorterData;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinations;
import mcjty.rftoolsutility.modules.teleporter.items.porter.AdvancedChargedPorterItem;
import mcjty.rftoolsutility.modules.teleporter.items.teleportprobe.TeleportProbeItem;
import mcjty.rftoolsutility.modules.teleporter.network.PacketTargetsReady;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PorterTools {
    public static void clearTarget(Player player, int index) {
        ItemStack heldItem = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (heldItem.isEmpty()) {
            return;
        }
        ChargedPorterData data = (ChargedPorterData)heldItem.get(TeleporterModule.ITEM_CHARGEDPORTER_DATA);
        if (data != null) {
            int old = data.getTarget(index);
            if ((data = data.withTarget(index, -1)).currentTarget() == old) {
                data = data.withCurrentTarget(-1);
            }
            heldItem.set(TeleporterModule.ITEM_CHARGEDPORTER_DATA, (Object)data);
        }
    }

    public static void forceTeleport(Player player, ResourceKey<Level> dimension, BlockPos pos) {
        boolean probeInOffHand;
        boolean probeInMainHand = !player.getMainHandItem().isEmpty() && player.getMainHandItem().getItem() instanceof TeleportProbeItem;
        boolean bl = probeInOffHand = !player.getOffhandItem().isEmpty() && player.getOffhandItem().getItem() instanceof TeleportProbeItem;
        if (!probeInMainHand && !probeInOffHand) {
            return;
        }
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        ResourceKey currentId = player.getCommandSenderWorld().dimension();
        if (!currentId.equals(dimension)) {
            TeleportationTools.teleportToDimension((Player)player, dimension, (double)((double)x + 0.5), (double)(y + 1), (double)((double)z + 0.5));
        } else {
            player.teleportTo((double)x + 0.5, (double)y + 1.5, (double)z + 0.5);
        }
    }

    public static void cycleDestination(Player player, boolean next) {
        ItemStack stack = player.getMainHandItem();
        PorterTools.cycleDestination(player, next, stack);
    }

    public static void cycleDestination(Player player, boolean next, ItemStack stack) {
        if (!stack.isEmpty() && stack.getItem() instanceof AdvancedChargedPorterItem) {
            ChargedPorterData data = (ChargedPorterData)stack.get(TeleporterModule.ITEM_CHARGEDPORTER_DATA);
            if (data == null) {
                return;
            }
            TeleportDestinations destinations = TeleportDestinations.get(player.getCommandSenderWorld());
            int curtarget = data.currentTarget();
            int donext = 0;
            for (int i = 0; i < 16; ++i) {
                AtomicInteger newTarget = new AtomicInteger(-1);
                int tgt = next ? i % 8 : (16 - i) % 8;
                if ((donext = PorterTools.checkTarget(player, data, destinations, newTarget, curtarget, donext, tgt)) != 2) continue;
                data = data.withCurrentTarget(newTarget.get());
                stack.set(TeleporterModule.ITEM_CHARGEDPORTER_DATA, (Object)data);
                break;
            }
        }
    }

    private static int checkTarget(Player playerEntity, ChargedPorterData data, TeleportDestinations destinations, AtomicInteger newTarget, int curtarget, int donext, int tgt) {
        TeleportDestination destination;
        int target;
        GlobalPos gc;
        if (data.getTarget(tgt) != -1 && (gc = destinations.getCoordinateForId(target = data.getTarget(tgt))) != null && (destination = destinations.getDestination(gc)) != null) {
            if (donext == 1) {
                String name = destination.getName() + " (dimension " + destination.getDimension().location().getPath() + ")";
                newTarget.set(target);
                MutableComponent component = ComponentFactory.literal((String)(String.valueOf(ChatFormatting.GREEN) + "Target: " + String.valueOf(ChatFormatting.WHITE) + name));
                if (playerEntity != null) {
                    playerEntity.displayClientMessage((Component)component, false);
                }
                donext = 2;
            } else if (target == curtarget) {
                donext = 1;
            }
        }
        return donext;
    }

    public static void returnDestinationInfo(Player player, int receiverId) {
        Level world = player.getCommandSenderWorld();
        TeleportDestinations destinations = TeleportDestinations.get(world);
        String name = TeleportDestinations.getDestinationName(destinations, receiverId);
        RFToolsUtilityMessages.sendToClient(player, "returnDestinationInfo", TypedMap.builder().put(ClientCommandHandler.PARAM_ID, (Object)receiverId).put(ClientCommandHandler.PARAM_NAME, (Object)name));
    }

    public static void setTarget(Player player, int target) {
        ItemStack heldItem = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (heldItem.isEmpty()) {
            return;
        }
        ChargedPorterData data = (ChargedPorterData)heldItem.get(TeleporterModule.ITEM_CHARGEDPORTER_DATA);
        if (data != null) {
            data = data.withCurrentTarget(target);
            heldItem.set(TeleporterModule.ITEM_CHARGEDPORTER_DATA, (Object)data);
        }
    }

    public static void returnTargets(Player player) {
        ItemStack heldItem = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (heldItem.isEmpty()) {
            return;
        }
        ChargedPorterData data = (ChargedPorterData)heldItem.get(TeleporterModule.ITEM_CHARGEDPORTER_DATA);
        int target = -1;
        int[] targets = new int[8];
        String[] names = new String[8];
        TeleportDestinations destinations = TeleportDestinations.get(player.getCommandSenderWorld());
        if (data != null) {
            target = data.currentTarget();
            for (int i = 0; i < 8; ++i) {
                names[i] = "";
                if (data.getTarget(i) != -1) {
                    TeleportDestination destination;
                    targets[i] = data.getTarget(i);
                    GlobalPos gc = destinations.getCoordinateForId(targets[i]);
                    if (gc == null || (destination = destinations.getDestination(gc)) == null) continue;
                    names[i] = destination.getName() + " (dimension " + destination.getDimension().location().getPath() + ")";
                    continue;
                }
                targets[i] = -1;
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                targets[i] = -1;
                names[i] = "";
            }
        }
        RFToolsUtilityMessages.sendToPlayer(PacketTargetsReady.create(target, targets, names), player);
    }
}

